/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.udp;

import at.mrdevelopment.esl.accesspoint.controller.udp.UDPClient;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.udp.UDPRunnable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;

public class UDPReceiver
extends UDPRunnable {
    private static ESLLogger logger = ESLLogger.getLogger(UDPReceiver.class);
    private final UDPClient udpClient;
    private boolean timeouts = false;

    UDPReceiver(DatagramSocket serverSocket, UDPClient udpClient) {
        super(serverSocket);
        this.udpClient = udpClient;
    }

    protected void periodicTask() {
        block5: {
            try {
                byte[] receiveData = new byte[74];
                DatagramPacket packet = new DatagramPacket(receiveData, receiveData.length);
                this.socket.receive(packet);
                if (this.timeouts) {
                    this.timeouts = false;
                    logger.info("Timeouts on read stopped for AP = %d.", new Object[]{this.udpClient.getApId()});
                }
                this.udpClient.receive(packet);
            }
            catch (SocketTimeoutException ste) {
                if (!this.shutdownRequested && !this.timeouts) {
                    logger.warn("Timeouts on read started for AP = %d.", new Object[]{this.udpClient.getApId()});
                    this.timeouts = true;
                }
            }
            catch (Exception exc) {
                if (this.shutdownRequested) break block5;
                logger.warn("Error receiving data: %s", new Object[]{exc.getMessage()});
                logger.logException((Throwable)exc);
            }
        }
    }
}

