/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.udp;

import at.mrdevelopment.esl.accesspoint.controller.udp.DefaultCurrentDate;
import at.mrdevelopment.esl.accesspoint.controller.udp.ThinAPCongestionStatistics;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPConsumer;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPReceiveStrategy;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPReceiver;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class UDPClient
implements Shutdownable {
    private static ESLLogger logger = ESLLogger.getLogger(UDPClient.class);
    private final int apId;
    private final int destinationPort;
    private final int localPort;
    private final DatagramSocket serverSocket;
    private final UDPReceiveStrategy strategy;
    private UDPReceiver udpReceiver;
    private UDPConsumer udpSender;
    private Thread udpReceiverThread;
    private Thread udpSenderThread;
    private final ArrayBlockingQueue<DatagramPacket> datagramQueue;
    private final AtomicReference<DatagramPacket> packetToSend;
    private final ThinAPCongestionStatistics congestionStatistics;

    public UDPClient(UDPReceiveStrategy strategy, int apId, int destinationPort, int localPort) throws SocketException {
        this.strategy = strategy;
        this.apId = apId;
        this.destinationPort = destinationPort;
        this.localPort = localPort;
        this.datagramQueue = new ArrayBlockingQueue(64);
        this.packetToSend = new AtomicReference<Object>(null);
        this.serverSocket = new DatagramSocket(localPort);
        this.serverSocket.setSoTimeout(240);
        this.serverSocket.setReceiveBufferSize(148000);
        this.congestionStatistics = new ThinAPCongestionStatistics(apId, new DefaultCurrentDate());
        logger.info("Receive buffer size: %d.", new Object[]{this.serverSocket.getReceiveBufferSize()});
        logger.info("Send buffer size: %d.", new Object[]{this.serverSocket.getSendBufferSize()});
    }

    public int getApId() {
        return this.apId;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public boolean runningOnPort(int port) {
        return this.destinationPort == port;
    }

    public void receive(DatagramPacket packet) throws Exception {
        if (!this.datagramQueue.offer(packet)) {
            logger.info("DatagramQueue for AP = %d is full!", new Object[]{this.apId});
        }
    }

    private void receive(DatagramPacket packet, boolean toSend) {
        try {
            this.strategy.receivedData(this, packet, toSend);
        }
        catch (Exception e) {
            logger.logException((Throwable)e);
        }
    }

    private int getLength(DatagramPacket packet) {
        return packet.getData()[0] & 0xFF;
    }

    private void receiveBatch(ArrayList<DatagramPacket> packets, boolean[] toSend) {
        for (int idx = 0; idx < packets.size(); ++idx) {
            if (packets.get(idx) != null) {
                this.receive(packets.get(idx), toSend[idx]);
                continue;
            }
            logger.error("Could not process packet for AP-ID: %d.", new Object[]{this.apId});
        }
    }

    public void consume() {
        try {
            DatagramPacket firstRequest;
            DatagramPacket sendPacket = this.packetToSend.getAndSet(null);
            if (sendPacket != null) {
                try {
                    this.serverSocket.send(sendPacket);
                }
                catch (IOException e) {
                    logger.logException((Throwable)e);
                }
            }
            if ((firstRequest = this.datagramQueue.poll(30L, TimeUnit.MILLISECONDS)) == null) {
                return;
            }
            int packetNum = this.datagramQueue.size();
            if (packetNum > 0) {
                ArrayList<DatagramPacket> packets = new ArrayList<DatagramPacket>(packetNum + 1);
                packets.add(firstRequest);
                this.datagramQueue.drainTo(packets);
                boolean[] toSend = new boolean[packets.size()];
                boolean isLastReceivedRequest = true;
                int slotRequestCount = 0;
                for (int idx = packets.size() - 1; idx >= 0; --idx) {
                    if (((DatagramPacket)packets.get(idx)).getData().length < 2) {
                        packets.set(idx, null);
                        continue;
                    }
                    if (this.getLength(packets.get(idx)) == 174) {
                        ++slotRequestCount;
                        if (isLastReceivedRequest) {
                            toSend[idx] = true;
                            isLastReceivedRequest = false;
                            continue;
                        }
                        toSend[idx] = false;
                        continue;
                    }
                    toSend[idx] = true;
                }
                if (slotRequestCount >= 2) {
                    this.congestionStatistics.newCongestion(slotRequestCount);
                    logger.warn("Congestion event!!!");
                }
                this.receiveBatch(packets, toSend);
            } else {
                this.receive(firstRequest, true);
                this.congestionStatistics.export();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendMessage(String message, InetAddress address) {
        this.sendMessage(message.getBytes(), address);
    }

    public void sendMessage(byte[] dataToSend, InetAddress address) {
        DatagramPacket packet = this.packetToSend.getAndSet(new DatagramPacket(dataToSend, dataToSend.length, address, this.destinationPort));
        if (packet != null) {
            logger.warn("Overwritten packet to send for AP = %d.", new Object[]{this.apId});
        }
    }

    public void setName(int apId) {
        if (this.udpReceiverThread != null) {
            this.udpReceiverThread.setName(String.format("UDPReceiver for apId %d", apId));
        }
        if (this.udpSenderThread != null) {
            this.udpSenderThread.setName(String.format("UDPSender for apId %d", apId));
        }
    }

    public void start() {
        this.udpReceiver = new UDPReceiver(this.serverSocket, this);
        this.udpReceiverThread = new Thread((Runnable)((Object)this.udpReceiver));
        this.udpSender = new UDPConsumer(this);
        this.udpSenderThread = new Thread((Runnable)((Object)this.udpSender));
        this.udpSenderThread.start();
        this.udpReceiverThread.start();
    }

    public void shutdown() {
        logger.info("Shutting down UDPClient for AP-ID %d", new Object[]{this.apId});
        if (this.udpReceiver != null) {
            this.udpReceiver.shutdown();
        }
        if (this.udpSender != null) {
            this.udpSender.shutdown();
        }
        if (this.udpReceiverThread != null) {
            this.udpReceiverThread.interrupt();
        }
        if (this.udpSenderThread != null) {
            this.udpSenderThread.interrupt();
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }
}

