/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.udp;

import at.mrdevelopment.esl.accesspoint.UDPAccessPoint;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointController;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointInfoHolder;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointModel;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPAPDispatcher;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPAccessPointModel;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;

public class UDPAccessPointController
extends AccessPointController {
    private static ESLLogger logger = ESLLogger.getLogger(UDPAccessPointController.class);
    private UDPAccessPointModel model;
    private UDPAPDispatcher dispatcher;
    private final int startingLocalPort;
    private final int lastLocalPort;

    public UDPAccessPointController(boolean removeOnShutdown, int startingLocalPort, int lastLocalPort, AccessPointInfoHolder infoHolder) throws InitializationException {
        this(removeOnShutdown, false, startingLocalPort, lastLocalPort, infoHolder);
    }

    public UDPAccessPointController(boolean removeOnShutdown, boolean ignoreAccessPointId, int startingLocalPort, int lastLocalPort, AccessPointInfoHolder infoHolder) throws InitializationException {
        super(removeOnShutdown, ignoreAccessPointId, infoHolder);
        this.startingLocalPort = startingLocalPort;
        this.lastLocalPort = lastLocalPort;
        this.initializeModelAndDispatch();
    }

    @Override
    protected void initializeModelAndDispatch() throws InitializationException {
        this.model = new UDPAccessPointModel();
        this.dispatcher = new UDPAPDispatcher(this.model, this.startingLocalPort, this.lastLocalPort, this.infoHolder);
        for (Integer key : this.model.getAccessPointKeys()) {
            UDPAccessPoint accessPoint = this.createUDPAccessPoint(this.model.getConfiguration(key));
            this.model.addAccessPoint(key, accessPoint);
        }
    }

    private UDPAccessPoint createUDPAccessPoint(ThinAccessPointConfiguration configuration) throws InitializationException {
        logger.debug("Starting UDP access point with configuration: %s", new Object[]{configuration.toString()});
        return new UDPAccessPoint(configuration, this.dispatcher, this.ignoreAccessPointId);
    }

    @Override
    protected void shutdownAccessPoint(Integer key) {
        if (this.model.isRunning(key)) {
            logger.info("Shutting down access point %s", new Object[]{key});
            UDPAccessPoint accessPoint = (UDPAccessPoint)this.model.getAccessPoint(key);
            accessPoint.shutdown();
            if (this.removeOnShutdown) {
                this.model.removeAccessPoint(key);
            }
        }
    }

    @Override
    public void addAccessPoint(ThinAccessPointConfiguration configuration) throws InitializationException {
        UDPAccessPoint udpAccessPoint = this.createUDPAccessPoint(configuration);
        this.model.addAccessPoint((Integer)configuration.getAccessPointId(), udpAccessPoint);
    }

    @Override
    public void removeAccessPoint(ThinAccessPointConfiguration configuration) {
        this.shutdownAccessPoint(configuration.getAccessPointId());
        configuration.getServerConfiguration().shutdown();
        this.model.removeAccessPoint(configuration.getAccessPointId());
    }

    @Override
    protected void innerShutdown() {
        this.dispatcher.shutdown();
    }

    @Override
    protected List<Integer> getAccessPointKeys() {
        return this.model.getAccessPointKeys();
    }

    public AccessPointModel<UDPAccessPoint> getModel() {
        return this.model;
    }

    public void setModel(UDPAccessPointModel model) {
        this.dispatcher.shutdown();
        this.model = model;
        this.dispatcher = new UDPAPDispatcher(model, this.startingLocalPort, this.lastLocalPort, this.infoHolder);
    }

    @Override
    public boolean isRunning(ThinAccessPointConfiguration configuration) {
        return this.model.isRunning(configuration);
    }
}

