/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.udp;

import at.mrdevelopment.esl.accesspoint.AccessPointMessageForwarder;
import at.mrdevelopment.esl.accesspoint.UDPAccessPoint;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointInfoHolder;
import at.mrdevelopment.esl.accesspoint.controller.BaseAPDispatcher;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPAccessPointModel;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPClient;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPReceiveStrategy;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class UDPAPDispatcher
extends BaseAPDispatcher<UDPAccessPoint>
implements UDPReceiveStrategy,
AccessPointMessageForwarder {
    private static final ESLLogger logger = ESLLogger.getLogger(UDPAPDispatcher.class);
    private static final int COMMUNICATION_TIMEOUT_SECONDS = 5;
    private static final String INIT_MESSAGE = "init";
    private final Map<Integer, UDPClient> clients = new ConcurrentHashMap<Integer, UDPClient>();
    private final Map<Integer, DateTime> lastMessages = new ConcurrentHashMap<Integer, DateTime>();
    private final SortedSet<Integer> availableLocalPorts = new TreeSet<Integer>();
    private final AccessPointInfoHolder infoHolder;

    public UDPAPDispatcher(UDPAccessPointModel model, int startingLocalPort, int lastLocalPort, AccessPointInfoHolder infoHolder) {
        super(model);
        this.infoHolder = infoHolder;
        for (int idx = startingLocalPort; idx <= lastLocalPort; ++idx) {
            this.availableLocalPorts.add(idx);
        }
        this.start();
    }

    private Integer getNewLocalPort() {
        if (this.availableLocalPorts.isEmpty()) {
            return null;
        }
        Integer tempPort = this.availableLocalPorts.first();
        this.availableLocalPorts.remove(tempPort);
        return tempPort;
    }

    private void returnLocalPort(Integer port) {
        this.availableLocalPorts.add(port);
    }

    @Override
    protected void innerShutdown() {
        for (UDPClient client : this.clients.values()) {
            client.shutdown();
        }
        this.clients.clear();
    }

    private void createClient(Integer apId, int port, LinkedList<Integer> boundPorts) {
        boolean creationNotSuccessful = true;
        do {
            Integer newLocalPort = null;
            try {
                newLocalPort = this.getNewLocalPort();
                if (newLocalPort != null) {
                    UDPClient client = new UDPClient(this, apId, port, newLocalPort);
                    client.start();
                    client.setName(apId);
                    this.clients.put(apId, client);
                    logger.info("Added client for %d with local port %d.", new Object[]{(int)apId, newLocalPort});
                    if (this.infoHolder != null) {
                        this.infoHolder.setLocalPort(apId, newLocalPort);
                    }
                } else {
                    logger.error("Could not create UDP client, no local port available.");
                    break;
                }
                creationNotSuccessful = false;
            }
            catch (SocketException se) {
                boundPorts.add(newLocalPort);
                logger.warn("Local port %d is already bound to a different process.", new Object[]{newLocalPort});
            }
        } while (creationNotSuccessful);
        if (creationNotSuccessful) {
            logger.error("Could not create UDP socket for AP = %d, was most likely unable to find free local port.", new Object[]{(int)apId});
        }
    }

    private void recreateClientIfWrongPort(Integer apId, int port, boolean permanentlyOffline, LinkedList<Integer> boundPorts) {
        UDPClient client = this.clients.get(apId);
        if (client != null && !client.runningOnPort(port)) {
            this.removeClient(apId);
            if (!permanentlyOffline) {
                this.createClient(apId, port, boundPorts);
            }
        }
    }

    private boolean isClientAvailable(Integer apId) {
        return this.clients.containsKey(apId);
    }

    @Override
    protected void createClientsIfNotPresentFor(Collection<ThinAccessPointConfiguration> runningConfigurations) {
        LinkedList<Integer> boundPorts = new LinkedList<Integer>();
        for (ThinAccessPointConfiguration configuration : runningConfigurations) {
            Integer apId = configuration.getAccessPointId();
            if (!this.isClientAvailable(apId)) {
                if (configuration.isPermanentlyOffline()) continue;
                this.createClient(apId, configuration.getRemotePort(), boundPorts);
                continue;
            }
            this.recreateClientIfWrongPort(apId, configuration.getRemotePort(), configuration.isPermanentlyOffline(), boundPorts);
        }
        this.availableLocalPorts.addAll(boundPorts);
    }

    private Iterable<Integer> getUnusedClients(final Collection<ThinAccessPointConfiguration> runningConfigurations) {
        return Iterables.filter(this.clients.keySet(), (Predicate)new Predicate<Integer>(){

            public boolean apply(Integer input) {
                for (ThinAccessPointConfiguration configuration : runningConfigurations) {
                    if (configuration.getAccessPointId() != input.intValue()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private void removeClient(Integer apId) {
        UDPClient client = this.clients.get(apId);
        if (client != null) {
            client.shutdown();
            this.clients.remove(apId);
            this.returnLocalPort(client.getLocalPort());
            if (this.infoHolder != null) {
                this.infoHolder.setLocalPort(apId, null);
            }
            logger.info("Removed client for %d.", new Object[]{(int)apId});
        }
    }

    private boolean existLatestMessageTimeFor(ThinAccessPointConfiguration configuration) {
        return !configuration.isPermanentlyOffline() && this.lastMessages.containsKey(configuration.getAccessPointId());
    }

    private boolean didConnectionTimeout(Integer apId) {
        return this.lastMessages.get(apId).plusSeconds(5).isBefore((ReadableInstant)DateTime.now());
    }

    @Override
    protected void removeClientsWithNoConfigIn(Collection<ThinAccessPointConfiguration> runningConfigurations) {
        Iterable<Integer> unusedClientApIds = this.getUnusedClients(runningConfigurations);
        for (Integer apId : unusedClientApIds) {
            this.removeClient(apId);
        }
    }

    @Override
    protected void sendInitMessage(ThinAccessPointConfiguration configuration) throws IOException {
        UDPClient client = this.clients.get(configuration.getAccessPointId());
        configuration.resolveInetAddress();
        if (client != null) {
            client.sendMessage(INIT_MESSAGE, configuration.getInetAddress());
        }
    }

    @Override
    protected void checkConnectionStatus(ThinAccessPointConfiguration configuration) {
        if (this.existLatestMessageTimeFor(configuration)) {
            UDPAccessPoint accessPoint = (UDPAccessPoint)this.model.getAccessPoint(configuration.getAccessPointId());
            if (this.didConnectionTimeout(configuration.getAccessPointId())) {
                accessPoint.setConnectionStatus(ConnectionStatus.OFFLINE);
            } else {
                accessPoint.setConnectionStatus(ConnectionStatus.ONLINE);
            }
        } else {
            ((UDPAccessPoint)this.model.getAccessPoint(configuration.getAccessPointId())).setConnectionStatus(ConnectionStatus.OFFLINE);
        }
    }

    @Override
    protected boolean shouldSendInitMessage(ThinAccessPointConfiguration configuration) {
        if (configuration.isPermanentlyOffline()) {
            return false;
        }
        Integer apId = configuration.getAccessPointId();
        if (this.lastMessages.containsKey(apId)) {
            if (!this.didConnectionTimeout(apId)) {
                return false;
            }
            logger.warn("UDP connection to thin AP %d (%s:%d) timed out (not reachable for more than %d seconds)", new Object[]{configuration.getAccessPointId(), configuration.getRemoteAddress(), configuration.getRemotePort(), 5});
        } else {
            logger.warn("Not connected to thin AP %d (%s:%d)", new Object[]{configuration.getAccessPointId(), configuration.getRemoteAddress(), configuration.getRemotePort()});
        }
        return true;
    }

    @Override
    public void receivedData(UDPClient client, DatagramPacket packet, boolean toSend) throws Exception {
        UDPAccessPoint accessPoint = (UDPAccessPoint)this.model.getAccessPoint(client.getApId());
        if (accessPoint != null) {
            ThinAccessPointConfiguration configuration = accessPoint.getConfiguration();
            this.lastMessages.put(configuration.getAccessPointId(), DateTime.now());
            accessPoint.receivedMessage(packet, this, toSend);
        } else {
            logger.error("No access point for Id: %d.", new Object[]{client.getApId()});
        }
    }

    public void forwardMessage(String message, int apId) throws IOException {
        this.forwardMessage(message.getBytes(), apId);
    }

    public void forwardMessage(byte[] data, int apId) throws IOException {
        ThinAccessPointConfiguration config = this.model.getConfiguration(apId);
        if (config != null) {
            if (!config.isPermanentlyOffline()) {
                UDPClient client = this.clients.get(apId);
                if (client != null) {
                    client.sendMessage(data, config.getInetAddress());
                } else {
                    logger.error("Sending UDP message, no client for AP = %d.", new Object[]{apId});
                }
            }
        } else {
            logger.error("Sending UDP message, no config for AP = %d.", new Object[]{apId});
        }
    }

    @Override
    protected void periodicInitialization() {
    }
}

