/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.udp;

import at.mrdevelopment.esl.accesspoint.controller.udp.CurrentDate;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class ThinAPCongestionStatistics {
    private static ESLLogger logger = ESLLogger.getLogger(ThinAPCongestionStatistics.class);
    private static int MAX_CONGESTION_THRESHOLD = 7;
    private static int MAX_HISTORY_DAYS = 7;
    private int[][] congestionCounts = new int[MAX_HISTORY_DAYS][MAX_CONGESTION_THRESHOLD];
    private int dayCount = 1;
    private int currentDayIdx = 0;
    private int exportCallCounter = 0;
    private int lastDayOfMonth;
    private CurrentDate currentDateProvider;
    private final int apId;

    public ThinAPCongestionStatistics(int apId, CurrentDate currentDateProvider) {
        this.currentDateProvider = currentDateProvider;
        this.lastDayOfMonth = currentDateProvider.getDayOfMonth();
        this.apId = apId;
    }

    private void doNewDay() {
        if (this.dayCount < MAX_HISTORY_DAYS) {
            ++this.dayCount;
            ++this.currentDayIdx;
        } else {
            ++this.currentDayIdx;
            this.currentDayIdx %= MAX_HISTORY_DAYS;
            for (int idx = 0; idx < MAX_CONGESTION_THRESHOLD; ++idx) {
                this.congestionCounts[this.currentDayIdx][idx] = 0;
            }
        }
    }

    public void newCongestion(int amount) {
        amount = (amount -= 2) >= 6 ? 6 : amount;
        int[] nArray = this.congestionCounts[this.currentDayIdx];
        int n = amount;
        nArray[n] = nArray[n] + 1;
    }

    public void export() {
        ++this.exportCallCounter;
        if (this.exportCallCounter % 2048 == 0 && this.isNewDay()) {
            this.doNewDay();
        }
        if (this.exportCallCounter == 8192) {
            this.innerExport();
            this.exportCallCounter = 0;
        }
    }

    private void innerExport() {
        int todayIdx = this.currentDayIdx;
        if (logger.isInfoEnabled()) {
            for (int day = 0; day < this.dayCount; ++day) {
                todayIdx = this.currentDayIdx - day < 0 ? MAX_HISTORY_DAYS + (this.currentDayIdx - day) : this.currentDayIdx - day;
                logger.info("Congestion statistics for AP=%d, day=%d: [%d, %d, %d, %d, %d, %d, %d]", new Object[]{this.apId, day, this.congestionCounts[todayIdx][0], this.congestionCounts[todayIdx][1], this.congestionCounts[todayIdx][2], this.congestionCounts[todayIdx][3], this.congestionCounts[todayIdx][4], this.congestionCounts[todayIdx][5], this.congestionCounts[todayIdx][6]});
            }
        }
    }

    private boolean isNewDay() {
        boolean result = false;
        int newDay = this.currentDateProvider.getDayOfMonth();
        if (this.lastDayOfMonth != newDay) {
            this.lastDayOfMonth = newDay;
            result = true;
        }
        return result;
    }
}

