/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.tcp.server;

import at.mrdevelopment.esl.accesspoint.tcp.DefaultTextPacketLogic;
import at.mrdevelopment.esl.accesspoint.tcp.TextPacketHandling;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPPacket;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigurationResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.OutboundIntroductionRequestPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.RawTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacketKind;

public class APCTextPacketLogic
implements TextPacketHandling {
    private static ESLLogger logger = ESLLogger.getLogger(APCTextPacketLogic.class);
    private PacketDestinationStrategy destinationStrategy;

    public void set(PacketDestinationStrategy destinationStrategy) {
        this.destinationStrategy = destinationStrategy;
    }

    private void handle(TCPSource source, RawTextPacket textPacket) {
        ThinAPTextPacketKind kind = ThinAPTextPacketKind.from((String)textPacket.getMessageKind());
        String[] pair = textPacket.getMessageType().split(": ");
        if (pair.length == 2 && "Message-Type".equals(pair[0].trim())) {
            OutboundIntroductionRequestPacket newPacket = null;
            String type = pair[1].trim();
            switch (kind) {
                case REQUEST: {
                    if (!type.equals("Introduction")) break;
                    newPacket = new OutboundIntroductionRequestPacket();
                    break;
                }
                case RESPONSE: {
                    if (!type.equals("Configuration")) break;
                    newPacket = new ConfigurationResponsePacket();
                    break;
                }
                default: {
                    logger.info("Got text message that was not a request, on the slot channel!");
                }
            }
            if (newPacket != null) {
                DefaultTextPacketLogic.setHeaders((RawTextPacket)textPacket, (ThinAPTextPacket)newPacket);
                if (newPacket.isValid()) {
                    newPacket.setSource(source);
                    this.destinationStrategy.accept((TCPPacket)newPacket);
                } else {
                    logger.debug("Packet %s is not valid", new Object[]{newPacket.getType()});
                }
            } else {
                logger.info("Got unsupported message - kind: %s, type: %s.", new Object[]{kind.getText(), type});
            }
        } else {
            logger.info("Could not handle following message-type line: %s. Ignoring everything afterwards.", new Object[]{textPacket.getMessageType()});
        }
    }

    public void handleTextPacket(TCPSource source, RawTextPacket packet) {
        this.handle(source, packet);
    }
}

