/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.tcp.server;

import at.mrdevelopment.esl.accesspoint.TCPAccessPoint;
import at.mrdevelopment.toolkit.borrow.BorrowResult;
import at.mrdevelopment.toolkit.borrow.BorrowStatus;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class APCTcpMultiplexor {
    private static ESLLogger logger = ESLLogger.getLogger(APCTcpMultiplexor.class);
    private final HashMap<Integer, Holder> accessPoints = new HashMap();

    public boolean add(TCPAccessPoint accessPoint) {
        boolean oldRemoved = false;
        if (!this.accessPoints.containsKey(accessPoint.getConfiguration().getAccessPointId())) {
            this.accessPoints.put(accessPoint.getConfiguration().getAccessPointId(), new Holder(accessPoint));
        } else {
            Holder existingAp = this.accessPoints.get(accessPoint.getConfiguration().getAccessPointId());
            if (existingAp.accessPoint != accessPoint && !existingAp.accessPoint.isRunning()) {
                this.accessPoints.remove(accessPoint.getConfiguration().getAccessPointId());
                this.accessPoints.put(accessPoint.getConfiguration().getAccessPointId(), new Holder(accessPoint));
                logger.debug("Removing old TCP access point with ID = %d!", new Object[]{accessPoint.getConfiguration().getAccessPointId()});
                oldRemoved = true;
            } else {
                logger.debug("Could not add TCP access point with ID = %d!", new Object[]{accessPoint.getConfiguration().getAccessPointId()});
            }
        }
        return oldRemoved;
    }

    List<Integer> createDiff(TreeSet<Integer> configuredIds) {
        LinkedList<Integer> results = new LinkedList<Integer>();
        for (Integer apId : this.accessPoints.keySet()) {
            if (configuredIds.contains(apId)) continue;
            results.add(apId);
        }
        return results;
    }

    RemovalResolution remove(Integer apId) {
        RemovalResolution resolution = RemovalResolution.SCHEDULED;
        Holder holder = this.accessPoints.get(apId);
        if (holder != null) {
            if (holder.available) {
                resolution = RemovalResolution.REMOVED;
                logger.debug("AccessPoint %d, was removed!", new Object[]{apId});
                this.accessPoints.remove(apId);
            } else {
                holder.scheduledForRemoval = true;
                logger.debug("AccessPoint %d, was scheduled for removal!", new Object[]{apId});
            }
        } else {
            logger.debug("Holder was null when removing!");
        }
        return resolution;
    }

    public BorrowResult<TCPAccessPoint> borrow(int apId) {
        BorrowResult result = null;
        Holder holder = this.accessPoints.get(apId);
        if (holder != null) {
            if (holder.available) {
                holder.available = false;
                result = new BorrowResult(BorrowStatus.SUCCESS, (Object)holder.accessPoint);
            } else {
                result = new BorrowResult(BorrowStatus.BORROWED, null);
            }
        } else {
            result = new BorrowResult();
        }
        return result;
    }

    public void giveBack(TCPAccessPoint accessPoint) {
        Holder holder = this.accessPoints.get(accessPoint.getConfiguration().getAccessPointId());
        if (holder != null) {
            if (!holder.available) {
                holder.available = true;
            }
            if (holder.scheduledForRemoval) {
                this.accessPoints.remove(accessPoint.getConfiguration().getAccessPointId());
                logger.debug("AccessPoint %d, was only now removed!", new Object[]{accessPoint.getConfiguration().getAccessPointId()});
            }
        } else {
            logger.debug("Holder was null, when giving back!");
        }
    }

    static enum RemovalResolution {
        SCHEDULED,
        REMOVED;

    }

    class Holder {
        TCPAccessPoint accessPoint;
        boolean available;
        boolean scheduledForRemoval;

        public Holder(TCPAccessPoint accessPoint) {
            this.accessPoint = accessPoint;
            this.available = true;
            this.scheduledForRemoval = false;
        }
    }
}

