/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.tcp.server;

import at.mrdevelopment.esl.accesspoint.TCPAccessPoint;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.tcp.server.APCTcpMultiplexor;
import at.mrdevelopment.toolkit.borrow.BorrowResult;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class APCTcpMultiplexContainer {
    private static ESLLogger logger = ESLLogger.getLogger(APCTcpMultiplexContainer.class);
    private final APCTcpMultiplexor apcMultiplexor = new APCTcpMultiplexor();
    private final HashMap<Integer, TCPAccessPoint> connectionIdToAccessPointMapping = new HashMap(16);
    private final HashMap<Integer, Integer> apIdToConnectionIdMapping = new HashMap(16);
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer add(TCPAccessPoint accessPoint) {
        Integer connId = null;
        try {
            this.lock.lock();
            if (this.apcMultiplexor.add(accessPoint)) {
                connId = this.apIdToConnectionIdMapping.remove(accessPoint.getConfiguration().getAccessPointId());
            }
        }
        finally {
            this.lock.unlock();
        }
        return connId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> createDiff(Collection<ThinAccessPointConfiguration> configurations) {
        List<Integer> diffList;
        TreeSet<Integer> tempConfigs = new TreeSet<Integer>();
        for (ThinAccessPointConfiguration conf : configurations) {
            tempConfigs.add(conf.getAccessPointId());
        }
        try {
            this.lock.lock();
            diffList = this.apcMultiplexor.createDiff(tempConfigs);
        }
        finally {
            this.lock.unlock();
        }
        return diffList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer scheduleForRemoval(Integer apId) {
        Integer connectionId = null;
        try {
            logger.debug("Scheduling AP = %d for removal!", new Object[]{(int)apId});
            this.lock.lock();
            APCTcpMultiplexor.RemovalResolution resolution = this.apcMultiplexor.remove(apId);
            if (resolution == APCTcpMultiplexor.RemovalResolution.REMOVED) {
                Integer tempConnId = this.apIdToConnectionIdMapping.remove(apId);
                if (tempConnId != null) {
                    this.connectionIdToAccessPointMapping.remove(tempConnId);
                }
            } else {
                connectionId = this.apIdToConnectionIdMapping.get(apId);
            }
        }
        finally {
            this.lock.unlock();
        }
        return connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BorrowResult<TCPAccessPoint> borrow(int apId) {
        BorrowResult<TCPAccessPoint> result = null;
        try {
            this.lock.lock();
            result = this.apcMultiplexor.borrow(apId);
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCPAccessPoint get(Integer connectionId) {
        TCPAccessPoint tempLogic = null;
        try {
            this.lock.lock();
            tempLogic = this.connectionIdToAccessPointMapping.get(connectionId);
        }
        finally {
            this.lock.unlock();
        }
        return tempLogic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getConnectionId(Integer apId) {
        Integer tempConnId = null;
        try {
            this.lock.lock();
            tempConnId = this.apIdToConnectionIdMapping.get(apId);
        }
        finally {
            this.lock.unlock();
        }
        return tempConnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapToOneAnother(Integer connectionId, TCPAccessPoint apLogic) {
        try {
            this.lock.lock();
            this.connectionIdToAccessPointMapping.put(connectionId, apLogic);
            this.apIdToConnectionIdMapping.put(apLogic.getConfiguration().getAccessPointId(), connectionId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectedDisconnect(Integer connectionId) {
        try {
            this.lock.lock();
            TCPAccessPoint tcpAp = this.connectionIdToAccessPointMapping.remove(connectionId);
            if (tcpAp != null) {
                this.apIdToConnectionIdMapping.remove(tcpAp.getConfiguration().getAccessPointId());
                logger.info("Got disconnect event for: %d! AP-ID = %d!", new Object[]{(int)connectionId, tcpAp.getConfiguration().getAccessPointId()});
                this.apcMultiplexor.giveBack(tcpAp);
            } else {
                logger.info("Got disconnect event for: %d! No ApLogic for conn.!", new Object[]{(int)connectionId});
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

