/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.tcp.server;

import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.TCPAccessPoint;
import at.mrdevelopment.esl.accesspoint.controller.tcp.server.APCProviderHolder;
import at.mrdevelopment.esl.accesspoint.controller.tcp.server.APCTcpEventStrategy;
import at.mrdevelopment.esl.accesspoint.controller.tcp.server.APCTcpMultiplexContainer;
import at.mrdevelopment.esl.accesspoint.tcp.DefaultBinaryPacketHandling;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.toolkit.borrow.BorrowResult;
import at.mrdevelopment.toolkit.borrow.BorrowStatus;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPPacket;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigurationRequestPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigurationResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.OutboundIntroductionRequestPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.OutboundIntroductionResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.OutboundIntroductionResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;

public class APCSlotChannelHandler
implements PacketDestinationStrategy {
    private static ESLLogger logger = ESLLogger.getLogger(APCSlotChannelHandler.class);
    private final APCTcpMultiplexContainer multiplexContainer;
    private final DefaultBinaryPacketHandling binaryPacketHandling;

    public APCSlotChannelHandler(APCTcpMultiplexContainer newMultiplexContainer, DefaultBinaryPacketHandling newBinaryPacketHandling) {
        this.multiplexContainer = newMultiplexContainer;
        this.binaryPacketHandling = newBinaryPacketHandling;
    }

    public int getApId() {
        return -1;
    }

    public void accept(TCPPacket packet) {
        TCPSource source = packet.getSource();
        ThinAPTextPacket textPacket = (ThinAPTextPacket)packet;
        if (textPacket.getType() == ThinAPPacketIdentifier.OUTBOUND_INTRODUCTION_REQUEST) {
            OutboundIntroductionRequestPacket request = (OutboundIntroductionRequestPacket)textPacket;
            if (2 == request.getProtocolVersion()) {
                BorrowResult<TCPAccessPoint> result = this.multiplexContainer.borrow(request.getAccessPointId());
                if (result.getStatus() == BorrowStatus.SUCCESS) {
                    try {
                        WirelessChannel channel = request.getEslChannel() < 0 ? null : WirelessChannel.getFromId((int)request.getEslChannel().shortValue());
                        ((TCPAccessPoint)result.getBorrowed()).updateFirmaware(request.getFwVersion());
                        APCProviderHolder newProvider = new APCProviderHolder();
                        ((TCPAccessPoint)result.getBorrowed()).setProviderHolder(newProvider);
                        newProvider.getDaemonInfoHolder().setData(request.getSwVersion(), request.getDeviceType());
                        ((TCPAccessPoint)result.getBorrowed()).updateMaxAllowedWindowSize(request.getMaxWindowSize());
                        ((TCPAccessPoint)result.getBorrowed()).updateChannel(channel);
                        this.multiplexContainer.mapToOneAnother(source.getChannel().getIdentifier().getId(), (TCPAccessPoint)result.getBorrowed());
                        this.binaryPacketHandling.setPacketDestinationStrategy((PacketDestinationStrategy)((TCPAccessPoint)result.getBorrowed()).getReplyReceiver());
                        byte[] response = OutboundIntroductionResponsePacket.create((OutboundIntroductionResponseCode)OutboundIntroductionResponseCode.SUCCESS);
                        source.submit(response, response.length);
                        byte[] packetData = ConfigurationRequestPacket.create();
                        source.submit(packetData, packetData.length);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        logger.error("Got invalid channel in %s message!", new Object[]{textPacket.getType().name()});
                        source.submitClose();
                    }
                } else if (result.getStatus() == BorrowStatus.BORROWED) {
                    byte[] response = OutboundIntroductionResponsePacket.create((OutboundIntroductionResponseCode)OutboundIntroductionResponseCode.ERROR_RETRY_LATER);
                    logger.info("Got: %s. Could not accept connection by SCD, closing channel. Still an active connection to [AP_ID] - [%d]", new Object[]{textPacket.getType().name(), request.getAccessPointId()});
                    source.submit(response, response.length);
                } else {
                    byte[] response = OutboundIntroductionResponsePacket.create((OutboundIntroductionResponseCode)OutboundIntroductionResponseCode.ERROR_AP_NOT_REGISTERED);
                    logger.error("Got: %s. Could not accept connection by SCD, closing channel. [AP_ID] - [%d] is not registered!", new Object[]{textPacket.getType().name(), request.getAccessPointId()});
                    source.submit(response, response.length);
                }
            } else {
                logger.error("Got: %s. Could not accept connection by SCD, closing channel. [PROTOCOL_VERSION] - expected: [%d], got: [%d].", new Object[]{textPacket.getType().name(), (byte)2, (byte)request.getProtocolVersion()});
                source.submitClose();
            }
        } else if (textPacket.getType() == ThinAPPacketIdentifier.CONFIGURATION_RESPONSE) {
            TCPAccessPoint accessPoint = this.multiplexContainer.get(source.getChannel().getIdentifier().getId());
            if (accessPoint != null) {
                ConfigurationResponsePacket response = (ConfigurationResponsePacket)textPacket;
                if (response.getResponseCode() == ConfigResponseCode.SUCCESS) {
                    accessPoint.getProviderHolder().getChannelStatusWrapper().slotChannelConnected();
                    accessPoint.getWirelessTransmitter().setFeatureSet(response.getFeatureSet());
                    APCTcpEventStrategy strategy = (APCTcpEventStrategy)source.getChannel().getProtocolStrategy();
                    strategy.setFeatures(response.getFeatureSet());
                    strategy.switchToBinary();
                    accessPoint.getWirelessTransmitter().reinitializeAndRestart(new SlotId(response.getInitialSlot().intValue()));
                    logger.info("Got: %s. Configuration successful.", new Object[]{textPacket.getType().name()});
                } else {
                    logger.error("Got: %s. Configuration failed.", new Object[]{textPacket.getType().name()});
                }
            } else {
                source.submitClose();
            }
        } else {
            logger.error("Got: %s, which is unhandled in logic.", new Object[]{textPacket.getType().name()});
        }
    }
}

