/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.tcp;

import at.mrdevelopment.esl.accesspoint.TCPAccessPoint;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointController;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointModel;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.tcp.TCPAPDispatcher;
import at.mrdevelopment.esl.accesspoint.tcp.TCPAccessPointSettings;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.extern.TCPTLSConfiguration;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;

public class TCPAccessPointController
extends AccessPointController {
    private static ESLLogger logger = ESLLogger.getLogger(TCPAccessPointController.class);
    private AccessPointModel<TCPAccessPoint> model;
    private TCPAPDispatcher dispatcher;
    private TCPAccessPointSettings accessPointSettings;
    private TCPTLSConfiguration tcpTLSConfiguration;

    public TCPAccessPointController(boolean removeOnShutdown, TCPAccessPointSettings accessPointSettings, TCPTLSConfiguration tcpTLSConfiguration) throws InitializationException {
        super(removeOnShutdown, null);
        this.accessPointSettings = accessPointSettings;
        this.tcpTLSConfiguration = tcpTLSConfiguration;
        this.initializeModelAndDispatch();
    }

    public TCPAccessPointController(boolean removeOnShutdown, boolean ignoreAccessPointId, TCPAccessPointSettings accessPointSettings) throws InitializationException {
        super(removeOnShutdown, ignoreAccessPointId, null);
        this.accessPointSettings = accessPointSettings;
        this.initializeModelAndDispatch();
    }

    @Override
    protected void initializeModelAndDispatch() throws InitializationException {
        this.model = new AccessPointModel();
        try {
            this.dispatcher = new TCPAPDispatcher(this.model, this.accessPointSettings, this.tcpTLSConfiguration);
        }
        catch (IOException ioe) {
            throw new InitializationException((Throwable)ioe);
        }
        catch (GeneralSecurityException gse) {
            throw new InitializationException((Throwable)gse);
        }
    }

    public void setModel(AccessPointModel<TCPAccessPoint> model) throws InitializationException {
        this.dispatcher.shutdown();
        this.model = model;
        try {
            this.dispatcher = new TCPAPDispatcher(model, this.accessPointSettings, this.tcpTLSConfiguration);
        }
        catch (IOException ioe) {
            throw new InitializationException((Throwable)ioe);
        }
        catch (GeneralSecurityException gse) {
            throw new InitializationException((Throwable)gse);
        }
    }

    @Override
    protected void innerShutdown() {
        if (this.dispatcher != null) {
            this.dispatcher.shutdown();
        }
    }

    private TCPAccessPoint createTCPAccessPoint(ThinAccessPointConfiguration configuration) throws InitializationException {
        logger.debug("Starting TCP access point with configuration: %s", new Object[]{configuration.toString()});
        TCPAccessPoint accessPoint = new TCPAccessPoint(this.dispatcher, configuration, WirelessChannel.CHANNEL_0, this.accessPointSettings);
        return accessPoint;
    }

    @Override
    protected void shutdownAccessPoint(Integer key) {
        if (this.model.isRunning(key)) {
            logger.info("Shutting down access point %d", new Object[]{key});
            TCPAccessPoint accessPoint = this.model.getAccessPoint(key);
            accessPoint.shutdown();
            if (this.removeOnShutdown) {
                this.model.removeAccessPoint(key);
            }
        }
    }

    @Override
    protected List<Integer> getAccessPointKeys() {
        if (this.model != null) {
            return this.model.getAccessPointKeys();
        }
        return Collections.emptyList();
    }

    @Override
    public void addAccessPoint(ThinAccessPointConfiguration configuration) throws InitializationException {
        TCPAccessPoint tcpAccessPoint = this.createTCPAccessPoint(configuration);
        this.model.addAccessPoint(configuration.getAccessPointId(), tcpAccessPoint);
    }

    @Override
    public void removeAccessPoint(ThinAccessPointConfiguration configuration) {
        this.shutdownAccessPoint(configuration.getAccessPointId());
        this.model.removeAccessPoint(configuration.getAccessPointId());
    }

    @Override
    public boolean isRunning(ThinAccessPointConfiguration configuration) {
        return this.model.isRunning(configuration);
    }

    public AccessPointModel<TCPAccessPoint> getModel() {
        return this.model;
    }
}

