/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.tcp;

import at.mrdevelopment.esl.accesspoint.AccessPointConnectionManager;
import at.mrdevelopment.esl.accesspoint.ChannelStatusProvider;
import at.mrdevelopment.esl.accesspoint.DaemonInfoProvider;
import at.mrdevelopment.esl.accesspoint.TCPAccessPoint;
import at.mrdevelopment.esl.accesspoint.TCPReplyReceiver;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointModel;
import at.mrdevelopment.esl.accesspoint.controller.BaseAPDispatcher;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.tcp.server.APCProtocolStrategyFactory;
import at.mrdevelopment.esl.accesspoint.controller.tcp.server.APCProviderHolder;
import at.mrdevelopment.esl.accesspoint.controller.tcp.server.APCTcpMultiplexContainer;
import at.mrdevelopment.esl.accesspoint.tcp.AccessPointSettingsReceiver;
import at.mrdevelopment.esl.accesspoint.tcp.SlotChannelHandler;
import at.mrdevelopment.esl.accesspoint.tcp.TCPAccessPointSettings;
import at.mrdevelopment.esl.accesspoint.tcp.TCPHolder;
import at.mrdevelopment.esl.accesspoint.tcp.ThinAPProtocolV20Strategy;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.ProtocolStrategyFactory;
import at.mrdevelopment.toolkit.tcp.TCPChannel;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPConnectionParameters;
import at.mrdevelopment.toolkit.tcp.TCPCore;
import at.mrdevelopment.toolkit.tcp.TCPEventStrategy;
import at.mrdevelopment.toolkit.tcp.TCPServerChannel;
import at.mrdevelopment.toolkit.tcp.extern.TCPCoreConfig;
import at.mrdevelopment.toolkit.tcp.extern.TCPTLSConfiguration;
import at.mrdevelopment.toolkit.tcp.tasks.WriteTask;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class TCPAPDispatcher
extends BaseAPDispatcher<TCPAccessPoint>
implements AccessPointConnectionManager {
    private static final ESLLogger logger = ESLLogger.getLogger(TCPAPDispatcher.class);
    private final Map<Integer, TCPHolder> apId2ClientMapping = new ConcurrentHashMap<Integer, TCPHolder>();
    private APCTcpMultiplexContainer multiplexContainer;
    private ThinModeLogic thinModeLogic;
    private TCPCore tcpCore;
    private TCPCoreConfig tcpConfig;
    private TCPAccessPointSettings apSettings;

    public TCPAPDispatcher(AccessPointModel<TCPAccessPoint> model, TCPAccessPointSettings accessPointSettings, TCPTLSConfiguration tcpTLSConfiguration) throws IOException, GeneralSecurityException {
        super(model);
        this.tcpConfig = TCPCoreConfig.createTLSServerDefault((KeyManager[])tcpTLSConfiguration.getKeyManagers(), (TrustManager[])tcpTLSConfiguration.getTrustManagers());
        this.multiplexContainer = new APCTcpMultiplexContainer();
        this.apSettings = accessPointSettings;
        this.thinModeLogic = new ThinModeLogic(this.apSettings.lancomUseTcpThinMode(), this.apSettings.lancomUseTcpThinOutboundMode(), this.apSettings.useThinMode(), this.apSettings.accessPointsUseOutboundMode());
        this.tcpCore = new TCPCore(this.tcpConfig);
        this.tcpCore.start();
        this.start();
    }

    @Override
    protected void innerShutdown() {
        for (TCPHolder holder : this.apId2ClientMapping.values()) {
            holder.shutdown();
        }
        this.apId2ClientMapping.clear();
        this.tcpCore.shutdown();
    }

    private boolean isClientAvailable(int apId) {
        return this.apId2ClientMapping.containsKey(apId);
    }

    private void createClient(ThinAccessPointConfiguration configuration) {
        TCPAccessPoint accessPoint = (TCPAccessPoint)this.model.getAccessPoint(configuration);
        TCPCommunicationChannel channel = null;
        channel = this.thinModeLogic.doesInboundModeUseTLS() ? this.tcpCore.createTCPCommunicationChannel(this.tcpConfig, TCPConnectionParameters.TCP_TLS_AS_SERVER) : this.tcpCore.createTCPCommunicationChannel(this.tcpConfig, TCPConnectionParameters.BASIC_TCP);
        if (channel != null) {
            ThinAPProtocolV20Strategy protocolStrategy = new ThinAPProtocolV20Strategy(this.tcpConfig.getInputBufferSize(), configuration.getAccessPointId());
            TCPReplyReceiver replyReceiver = accessPoint.getReplyReceiver();
            SlotChannelHandler slotChannelHandler = new SlotChannelHandler(configuration.getAccessPointId(), (AccessPointSettingsReceiver)accessPoint, accessPoint.getWirelessTransmitter());
            replyReceiver.setSlotChannelHandler(slotChannelHandler);
            protocolStrategy.setTextPacketDestinationStrategy((PacketDestinationStrategy)replyReceiver);
            protocolStrategy.setBinaryPacketDestinationStrategy((PacketDestinationStrategy)replyReceiver);
            TCPHolder holder = new TCPHolder(slotChannelHandler, channel);
            accessPoint.setChannelStatusProvider((ChannelStatusProvider)holder);
            accessPoint.setDaemonInfoProvider((DaemonInfoProvider)holder);
            if (channel.creationSuccessful()) {
                this.tcpCore.register((TCPChannel)channel);
                channel.setProtocolStrategy((TCPEventStrategy)protocolStrategy);
                this.initiateConnection(channel, configuration);
                this.apId2ClientMapping.put(configuration.getAccessPointId(), holder);
            }
        }
    }

    private void reconnectClientIfNecessary(ThinAccessPointConfiguration configuration) {
        TCPHolder holder = this.apId2ClientMapping.get(configuration.getAccessPointId());
        TCPCommunicationChannel channel = holder.getChannel();
        if (channel.canConnect()) {
            logger.info("Doing a reconnect.");
            this.initiateConnection(channel, configuration);
        }
    }

    private void initiateConnection(TCPCommunicationChannel channel, ThinAccessPointConfiguration configuration) {
        int selectedTargetPort = AccessPointTypeMapping.getType((int)configuration.getAccessPointId()) == AccessPointType.SIMULATED ? configuration.getRemotePort() : (this.thinModeLogic.doesInboundModeUseTLS() ? 7354 : 7353);
        channel.establishConnection(configuration.getRemoteAddress(), selectedTargetPort, this.tcpCore);
        logger.info("Initiated the connection to: [%s - %d]", new Object[]{configuration.getRemoteAddress(), selectedTargetPort});
    }

    private void checkAndRemoveTimedoutConnections(Collection<ThinAccessPointConfiguration> runningConfigurations) {
        Iterator<Map.Entry<Integer, TCPHolder>> iterator = this.apId2ClientMapping.entrySet().iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry<Integer, TCPHolder> entry = iterator.next();
            TCPCommunicationChannel channel = entry.getValue().getChannel();
            if (!channel.isClosed() && (channel.getLastActivityTime() <= 0L || currentTime - channel.getLastActivityTime() <= 120000L)) continue;
            iterator.remove();
            entry.getValue().shutdown();
        }
    }

    private void innerAddAndShutdownCommChannelFor(ThinAccessPointConfiguration config) {
        TCPCommunicationChannel commChannel;
        Integer tempConnId = this.multiplexContainer.add((TCPAccessPoint)this.model.getAccessPoint(config));
        if (tempConnId != null && (commChannel = this.tcpCore.getChannelBy(tempConnId)) != null) {
            commChannel.shutdownOperation();
        }
    }

    @Override
    protected void createClientsIfNotPresentFor(Collection<ThinAccessPointConfiguration> runningConfigurations) {
        this.checkAndRemoveTimedoutConnections(runningConfigurations);
        for (ThinAccessPointConfiguration config : runningConfigurations) {
            AccessPointType type = AccessPointTypeMapping.getType((int)config.getAccessPointId());
            if (type == AccessPointType.LANCOM) {
                if (!this.thinModeLogic.lancomUseTcpThinMode()) continue;
                if (this.thinModeLogic.lancomUseTcpThinOutboundMode()) {
                    this.innerAddAndShutdownCommChannelFor(config);
                    continue;
                }
                if (!this.isClientAvailable(config.getAccessPointId())) {
                    this.createClient(config);
                    continue;
                }
                this.reconnectClientIfNecessary(config);
                continue;
            }
            if (this.thinModeLogic.shouldApsUseInboundMode()) {
                if (!this.isClientAvailable(config.getAccessPointId())) {
                    this.createClient(config);
                } else {
                    this.reconnectClientIfNecessary(config);
                }
            }
            if (!this.thinModeLogic.shouldApsUseOutboundMode()) continue;
            this.innerAddAndShutdownCommChannelFor(config);
        }
    }

    private void removeAllClientsInMapping(AccessPointType apType, boolean negate) {
        Iterator<Map.Entry<Integer, TCPHolder>> entryIterator = this.apId2ClientMapping.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Integer, TCPHolder> entry = entryIterator.next();
            AccessPointType tempType = AccessPointTypeMapping.getType((int)entry.getKey());
            if (negate) {
                if (tempType == apType) continue;
                entry.getValue().shutdown();
                entryIterator.remove();
                continue;
            }
            if (tempType != apType) continue;
            entry.getValue().shutdown();
            entryIterator.remove();
        }
    }

    private void removeAllClientsForApOutbound(Collection<ThinAccessPointConfiguration> runningConfigurations) {
        for (ThinAccessPointConfiguration config : runningConfigurations) {
            TCPCommunicationChannel commChannel;
            Integer tempConnId = this.multiplexContainer.scheduleForRemoval(config.getAccessPointId());
            if (tempConnId == null || (commChannel = this.tcpCore.getChannelBy(tempConnId)) == null) continue;
            commChannel.shutdownOperation();
        }
    }

    private void removeAndShutdownFromMultiplex(Collection<ThinAccessPointConfiguration> inputConfigs, AccessPointType type, boolean negate) {
        List<Integer> configuredApIds = this.multiplexContainer.createDiff(inputConfigs);
        for (Integer apId : configuredApIds) {
            TCPCommunicationChannel commChannel;
            Integer tempConnId;
            if (negate) {
                if (AccessPointTypeMapping.getType((int)apId) == type || (tempConnId = this.multiplexContainer.scheduleForRemoval(apId)) == null || (commChannel = this.tcpCore.getChannelBy(tempConnId)) == null) continue;
                commChannel.shutdownOperation();
                continue;
            }
            if (AccessPointTypeMapping.getType((int)apId) != type || (tempConnId = this.multiplexContainer.scheduleForRemoval(apId)) == null || (commChannel = this.tcpCore.getChannelBy(tempConnId)) == null) continue;
            commChannel.shutdownOperation();
        }
    }

    private void innerLoopConfigsRemoveClient(Iterator<Integer> clientIterator, int apId, List<ThinAccessPointConfiguration> apConfigs) {
        boolean hasNoConfig = true;
        for (ThinAccessPointConfiguration config : apConfigs) {
            if (config.getAccessPointId() != apId) continue;
            hasNoConfig = false;
            break;
        }
        if (hasNoConfig) {
            Shutdownable client = (Shutdownable)this.apId2ClientMapping.get(apId);
            if (client != null) {
                client.shutdown();
            }
            clientIterator.remove();
        }
    }

    private void innerRemoveClientWithNoConfig(List<ThinAccessPointConfiguration> apConfigs, AccessPointType apType, boolean negate) {
        Iterator<Integer> clientIterator = this.apId2ClientMapping.keySet().iterator();
        while (clientIterator.hasNext()) {
            int apId = clientIterator.next();
            AccessPointType tempType = AccessPointTypeMapping.getType((int)apId);
            if (negate) {
                if (tempType == apType) continue;
                this.innerLoopConfigsRemoveClient(clientIterator, apId, apConfigs);
                continue;
            }
            if (tempType != apType) continue;
            this.innerLoopConfigsRemoveClient(clientIterator, apId, apConfigs);
        }
    }

    @Override
    protected void removeClientsWithNoConfigIn(Collection<ThinAccessPointConfiguration> runningConfigurations) {
        LinkedList<ThinAccessPointConfiguration> lancomAps = new LinkedList<ThinAccessPointConfiguration>();
        LinkedList<ThinAccessPointConfiguration> otherAps = new LinkedList<ThinAccessPointConfiguration>();
        for (ThinAccessPointConfiguration tapc : runningConfigurations) {
            if (AccessPointTypeMapping.getType((int)tapc.getAccessPointId()) == AccessPointType.LANCOM) {
                lancomAps.add(tapc);
                continue;
            }
            otherAps.add(tapc);
        }
        if (this.thinModeLogic.lancomUseTcpThinMode()) {
            if (this.thinModeLogic.lancomUseTcpThinOutboundMode()) {
                if (this.thinModeLogic.hasLancomModeChanged()) {
                    this.removeAllClientsInMapping(AccessPointType.LANCOM, false);
                }
                this.removeAndShutdownFromMultiplex(lancomAps, AccessPointType.LANCOM, false);
            } else {
                if (this.thinModeLogic.hasLancomModeChanged()) {
                    this.removeAllClientsForApOutbound(lancomAps);
                }
                this.innerRemoveClientWithNoConfig(lancomAps, AccessPointType.LANCOM, false);
            }
        } else if (this.thinModeLogic.hasLancomModeChanged()) {
            this.removeAllClientsInMapping(AccessPointType.LANCOM, false);
            this.removeAllClientsForApOutbound(lancomAps);
        }
        if (this.thinModeLogic.useThinMode()) {
            if (this.thinModeLogic.useOutboundMode()) {
                if (this.thinModeLogic.hasModeChanged()) {
                    this.removeAllClientsInMapping(AccessPointType.LANCOM, true);
                }
                this.removeAndShutdownFromMultiplex(otherAps, AccessPointType.LANCOM, true);
            } else {
                if (this.thinModeLogic.hasModeChanged()) {
                    this.removeAllClientsForApOutbound(otherAps);
                }
                this.innerRemoveClientWithNoConfig(otherAps, AccessPointType.LANCOM, true);
            }
        } else if (this.thinModeLogic.hasModeChanged()) {
            this.removeAllClientsInMapping(AccessPointType.LANCOM, true);
            this.removeAllClientsForApOutbound(otherAps);
        }
    }

    private void innerOutboundModeSubmitMessage(byte[] dataArray, int dataLengthInBytes, int accessPointId) {
        TCPCommunicationChannel commChannel;
        Integer connId = this.multiplexContainer.getConnectionId(accessPointId);
        if (connId != null && (commChannel = this.tcpCore.getChannelBy(connId)) != null) {
            this.tcpCore.submit(new WriteTask(commChannel, dataArray, dataLengthInBytes));
        }
    }

    private void innerInboundModeSubmitMessage(byte[] dataArray, int dataLengthInBytes, int accessPointId) {
        TCPHolder tcpHolder = this.apId2ClientMapping.get(accessPointId);
        if (tcpHolder != null) {
            this.tcpCore.submit(new WriteTask(tcpHolder.getChannel(), dataArray, dataLengthInBytes));
        }
    }

    public void forwardMessage(byte[] dataArray, int dataLengthInBytes, int accessPointId) {
        AccessPointType apType = AccessPointTypeMapping.getType((int)accessPointId);
        if (apType == AccessPointType.LANCOM) {
            if (this.thinModeLogic.lancomUseTcpThinOutboundMode()) {
                this.innerOutboundModeSubmitMessage(dataArray, dataLengthInBytes, accessPointId);
            } else {
                this.innerInboundModeSubmitMessage(dataArray, dataLengthInBytes, accessPointId);
            }
        } else if (this.thinModeLogic.useOutboundMode()) {
            this.innerOutboundModeSubmitMessage(dataArray, dataLengthInBytes, accessPointId);
        } else {
            this.innerInboundModeSubmitMessage(dataArray, dataLengthInBytes, accessPointId);
        }
    }

    @Override
    protected void sendInitMessage(ThinAccessPointConfiguration configuration) throws IOException {
        logger.info("sendInitMessage not needed, for TCP ThinAP, sending the INIT packet is handled otherwise.");
    }

    @Override
    protected boolean shouldSendInitMessage(ThinAccessPointConfiguration configuration) {
        return false;
    }

    private boolean isAPOnline(Integer apId) {
        TCPHolder holder = this.apId2ClientMapping.get(apId);
        return !new DateTime(holder.getChannel().getLastActivityTime()).plusSeconds(120).isBefore((ReadableInstant)DateTime.now()) && !holder.getSlotChannelRemoteEndpoint().isEmpty();
    }

    private boolean isAPOnline(Integer connId, TCPAccessPoint accessPoint) {
        APCProviderHolder providerHolder;
        TCPCommunicationChannel commChannel;
        boolean isOnline = false;
        if (accessPoint != null && (commChannel = this.tcpCore.getChannelBy(connId)) != null && (providerHolder = accessPoint.getProviderHolder()) != null) {
            isOnline = !new DateTime(commChannel.getLastActivityTime()).plusSeconds(120).isBefore((ReadableInstant)DateTime.now()) && !providerHolder.getSlotChannelRemoteEndpoint().isEmpty();
        }
        return isOnline;
    }

    private boolean isTLSUsed(Integer apId) {
        TCPHolder holder = this.apId2ClientMapping.get(apId);
        return holder.getChannel().isTLSUsed();
    }

    private boolean isTLSUsed(Integer connId, TCPAccessPoint accessPoint) {
        TCPCommunicationChannel commChannel;
        boolean isTLSUsed = false;
        if (accessPoint != null && (commChannel = this.tcpCore.getChannelBy(connId)) != null) {
            isTLSUsed = commChannel.isTLSUsed();
        }
        return isTLSUsed;
    }

    private void createAndSetupNoTLSServerChannel() {
        TCPServerChannel tcpChannel = TCPServerChannel.createTCPServerChannel((TCPCoreConfig)this.tcpConfig, (ProtocolStrategyFactory)new APCProtocolStrategyFactory(this.tcpConfig.getInputBufferSize(), this.multiplexContainer), (TCPConnectionParameters)TCPConnectionParameters.BASIC_TCP);
        if (tcpChannel.bind("*", this.thinModeLogic.getAccessPointControllerPort())) {
            this.tcpCore.register((TCPChannel)tcpChannel);
            this.thinModeLogic.updateNoTLSServerChannel(tcpChannel);
        } else {
            logger.error("Could not bind to *:%d. Mentioned port is used for outbound no TLS connections.", new Object[]{this.thinModeLogic.getAccessPointControllerPort()});
        }
    }

    private void createAndSetupTLSServerChannel() {
        TCPServerChannel tcpChannel = TCPServerChannel.createTCPServerChannel((TCPCoreConfig)this.tcpConfig, (ProtocolStrategyFactory)new APCProtocolStrategyFactory(this.tcpConfig.getInputBufferSize(), this.multiplexContainer), (TCPConnectionParameters)TCPConnectionParameters.TCP_TLS_AS_SERVER);
        if (tcpChannel.bind("*", this.thinModeLogic.getAccessPointControllerTLSPort())) {
            this.tcpCore.register((TCPChannel)tcpChannel);
            this.thinModeLogic.updateTLSServerChannel(tcpChannel);
        } else {
            logger.error("Could not bind to *:%d. Mentioned port is used for outbound TLS connections.", new Object[]{this.thinModeLogic.getAccessPointControllerTLSPort()});
        }
    }

    @Override
    protected void periodicInitialization() {
        this.thinModeLogic.updateConfigFlags(this.apSettings.lancomUseTcpThinMode(), this.apSettings.lancomUseTcpThinOutboundMode(), this.apSettings.useThinMode(), this.apSettings.accessPointsUseOutboundMode(), this.apSettings.accessPointControllerPort(), this.apSettings.accessPointControllerTLSPort(), this.apSettings.areNonTLSConnectionsForOutboundModeDisabled(), this.apSettings.inboundModeUsesTLS());
        if (this.thinModeLogic.shouldApsUseOutboundMode() || this.thinModeLogic.shouldLancomsUseOutboundMode()) {
            if (!this.thinModeLogic.areNonTLSConnectionsForOutboundModeDisabled()) {
                if (!this.thinModeLogic.isNoTLSServerChannelPresent()) {
                    this.createAndSetupNoTLSServerChannel();
                } else if (this.thinModeLogic.hasNoTLSPortChanged()) {
                    this.thinModeLogic.closeAndRemoveNoTLSServerChannelIfPresent();
                    this.createAndSetupNoTLSServerChannel();
                }
                this.tcpCore.disableNonTLSConnectionRemoval();
            } else {
                this.thinModeLogic.closeAndRemoveNoTLSServerChannelIfPresent();
                this.tcpCore.enableNonTLSConnectionRemoval();
            }
            if (!this.thinModeLogic.isTLSServerChannelPresent()) {
                this.createAndSetupTLSServerChannel();
            } else if (this.thinModeLogic.hasTLSPortChanged()) {
                this.thinModeLogic.closeAndRemoveTLSServerChannelIfPresent();
                this.createAndSetupTLSServerChannel();
            }
        } else {
            this.thinModeLogic.closeAndRemoveNoTLSServerChannelIfPresent();
            this.thinModeLogic.closeAndRemoveTLSServerChannelIfPresent();
        }
        if ((this.thinModeLogic.shouldApsUseInboundMode() || this.thinModeLogic.lancomUseTcpThinMode()) && this.thinModeLogic.hasSecurityModeForInboundChanged()) {
            for (TCPHolder temp : this.apId2ClientMapping.values()) {
                temp.shutdown();
            }
            this.apId2ClientMapping.clear();
        }
    }

    private void innerSetConnectionStatusForOutbound(ThinAccessPointConfiguration configuration) {
        Integer connId = this.multiplexContainer.getConnectionId(configuration.getAccessPointId());
        if (connId != null) {
            TCPAccessPoint accessPoint;
            accessPoint.setConnectionStatus(this.isAPOnline(connId, accessPoint = (TCPAccessPoint)this.model.getAccessPoint(configuration.getAccessPointId())) ? ConnectionStatus.ONLINE : ConnectionStatus.OFFLINE);
            accessPoint.setProtocolUsingTLS(this.isTLSUsed(connId, accessPoint));
        } else {
            ((TCPAccessPoint)this.model.getAccessPoint(configuration.getAccessPointId())).setConnectionStatus(ConnectionStatus.OFFLINE);
        }
    }

    private void innerSetConnectionStatusForInbound(ThinAccessPointConfiguration configuration) {
        if (this.apId2ClientMapping.containsKey(configuration.getAccessPointId())) {
            TCPAccessPoint accessPoint = (TCPAccessPoint)this.model.getAccessPoint(configuration.getAccessPointId());
            accessPoint.setConnectionStatus(this.isAPOnline(configuration.getAccessPointId()) ? ConnectionStatus.ONLINE : ConnectionStatus.OFFLINE);
            accessPoint.setProtocolUsingTLS(this.isTLSUsed(configuration.getAccessPointId()));
        } else {
            ((TCPAccessPoint)this.model.getAccessPoint(configuration.getAccessPointId())).setConnectionStatus(ConnectionStatus.OFFLINE);
        }
    }

    @Override
    protected void checkConnectionStatus(ThinAccessPointConfiguration configuration) {
        if (AccessPointTypeMapping.getType((int)configuration.getAccessPointId()) == AccessPointType.LANCOM) {
            if (this.thinModeLogic.lancomUseTcpThinMode()) {
                if (this.thinModeLogic.lancomUseTcpThinOutboundMode()) {
                    this.innerSetConnectionStatusForOutbound(configuration);
                } else {
                    this.innerSetConnectionStatusForInbound(configuration);
                }
            }
        } else if (this.thinModeLogic.useThinMode()) {
            if (this.thinModeLogic.useOutboundMode()) {
                this.innerSetConnectionStatusForOutbound(configuration);
            } else {
                this.innerSetConnectionStatusForInbound(configuration);
            }
        }
    }

    private class ThinModeLogic {
        private boolean lancomUseTcpThinMode;
        private boolean lancomUseTcpThinOutboundMode;
        private boolean lancomModeChanged;
        private boolean useThinMode;
        private boolean useOutboundMode;
        private int accessPointControllerPort;
        private boolean noTLSPortChanged;
        private boolean modeChanged;
        private int accessPointControllerTLSPort;
        private boolean tlsPortChanged;
        private TCPServerChannel noTLSServerChannel;
        private TCPServerChannel tlsServerChannel;
        private boolean nonTLSConnectionsForOutboundModeDisabled;
        private boolean inboundModeUsesTLS;
        private boolean hasSecurityModeForInboundChanged;

        private ThinModeLogic(boolean lancomUseTcpThinMode, boolean lancomUseTcpThinOutboundMode, boolean useThinMode, boolean useOutboundMode) {
            this.lancomUseTcpThinMode = lancomUseTcpThinMode;
            this.lancomUseTcpThinOutboundMode = lancomUseTcpThinOutboundMode;
            this.useThinMode = useThinMode;
            this.useOutboundMode = useOutboundMode;
            this.noTLSServerChannel = null;
            this.tlsServerChannel = null;
            this.accessPointControllerPort = -1;
            this.accessPointControllerTLSPort = -1;
            this.noTLSPortChanged = false;
            this.tlsPortChanged = false;
            this.modeChanged = false;
            this.lancomModeChanged = false;
            this.nonTLSConnectionsForOutboundModeDisabled = false;
            this.inboundModeUsesTLS = false;
            this.hasSecurityModeForInboundChanged = false;
        }

        boolean lancomUseTcpThinMode() {
            return this.lancomUseTcpThinMode;
        }

        boolean lancomUseTcpThinOutboundMode() {
            return this.lancomUseTcpThinOutboundMode;
        }

        boolean hasLancomModeChanged() {
            return this.lancomModeChanged;
        }

        boolean shouldLancomsUseOutboundMode() {
            return this.lancomUseTcpThinMode && this.lancomUseTcpThinOutboundMode;
        }

        boolean useThinMode() {
            return this.useThinMode;
        }

        boolean useOutboundMode() {
            return this.useOutboundMode;
        }

        boolean shouldApsUseOutboundMode() {
            return this.useThinMode && this.useOutboundMode;
        }

        boolean shouldApsUseInboundMode() {
            return this.useThinMode && !this.useOutboundMode;
        }

        boolean isNoTLSServerChannelPresent() {
            return this.noTLSServerChannel != null;
        }

        boolean isTLSServerChannelPresent() {
            return this.tlsServerChannel != null;
        }

        boolean hasNoTLSPortChanged() {
            return this.noTLSPortChanged;
        }

        boolean hasTLSPortChanged() {
            return this.tlsPortChanged;
        }

        boolean hasModeChanged() {
            return this.modeChanged;
        }

        int getAccessPointControllerPort() {
            return this.accessPointControllerPort;
        }

        int getAccessPointControllerTLSPort() {
            return this.accessPointControllerTLSPort;
        }

        boolean areNonTLSConnectionsForOutboundModeDisabled() {
            return this.nonTLSConnectionsForOutboundModeDisabled;
        }

        boolean doesInboundModeUseTLS() {
            return this.inboundModeUsesTLS;
        }

        boolean hasSecurityModeForInboundChanged() {
            return this.hasSecurityModeForInboundChanged;
        }

        void closeAndRemoveNoTLSServerChannelIfPresent() {
            if (this.noTLSServerChannel != null) {
                this.noTLSServerChannel.shutdownOperation();
                this.noTLSServerChannel = null;
            }
        }

        void closeAndRemoveTLSServerChannelIfPresent() {
            if (this.tlsServerChannel != null) {
                this.tlsServerChannel.shutdownOperation();
                this.tlsServerChannel = null;
            }
        }

        void updateConfigFlags(boolean lancomUseTcpThinMode, boolean lancomUseTcpOutboundMode, boolean newUseThinMode, boolean newUseOutboundMode, int newApcPort, int newTLSApcPort, boolean nonTLSConnectionsDisabled, boolean inboundModeUsesTLS) {
            this.modeChanged = this.useThinMode != newUseThinMode || this.useOutboundMode != newUseOutboundMode;
            this.useThinMode = newUseThinMode;
            this.useOutboundMode = newUseOutboundMode;
            this.lancomModeChanged = this.lancomUseTcpThinMode != lancomUseTcpThinMode || this.lancomUseTcpThinOutboundMode != lancomUseTcpOutboundMode;
            this.lancomUseTcpThinMode = lancomUseTcpThinMode;
            this.lancomUseTcpThinOutboundMode = lancomUseTcpOutboundMode;
            this.noTLSPortChanged = this.accessPointControllerPort != newApcPort;
            this.accessPointControllerPort = newApcPort;
            this.tlsPortChanged = this.accessPointControllerTLSPort != newTLSApcPort;
            this.accessPointControllerTLSPort = newTLSApcPort;
            this.nonTLSConnectionsForOutboundModeDisabled = nonTLSConnectionsDisabled;
            this.hasSecurityModeForInboundChanged = this.inboundModeUsesTLS != inboundModeUsesTLS;
            this.inboundModeUsesTLS = inboundModeUsesTLS;
        }

        void updateNoTLSServerChannel(TCPServerChannel serverChannel) {
            this.noTLSServerChannel = serverChannel;
            this.noTLSPortChanged = false;
        }

        void updateTLSServerChannel(TCPServerChannel serverChannel) {
            this.tlsServerChannel = serverChannel;
            this.tlsPortChanged = false;
        }
    }
}

