/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller;

import at.mrdevelopment.esl.accesspoint.TCPAccessPoint;
import at.mrdevelopment.esl.accesspoint.UDPAccessPoint;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointModel;
import at.mrdevelopment.esl.accesspoint.controller.ControllerStatus;
import at.mrdevelopment.esl.accesspoint.controller.DuplicateEntryException;
import at.mrdevelopment.esl.accesspoint.controller.StandaloneThinAccessPointWebServerConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ThinAccessPointTableModel
extends AbstractTableModel {
    private final AccessPointModel<UDPAccessPoint> udpModel;
    private final AccessPointModel<TCPAccessPoint> tcpModel;
    private final List<ThinAccessPointConfiguration> configs;

    public ThinAccessPointTableModel(AccessPointModel<UDPAccessPoint> model, AccessPointModel<TCPAccessPoint> tcpModel, List<ThinAccessPointConfiguration> configs) {
        this.udpModel = model;
        this.tcpModel = tcpModel;
        this.configs = new ArrayList<ThinAccessPointConfiguration>(configs);
        Collections.sort(this.configs, new Comparator<ThinAccessPointConfiguration>(){

            @Override
            public int compare(ThinAccessPointConfiguration o1, ThinAccessPointConfiguration o2) {
                return o1.getAccessPointId() - o2.getAccessPointId();
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.configs.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return ControllerStatus.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "AP ID";
            }
            case 1: {
                return "Address";
            }
            case 2: {
                return "HTTP";
            }
            case 3: {
                return "UDP/TCP Port";
            }
            case 4: {
                return "Status";
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ThinAccessPointConfiguration configuration = this.configs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return configuration.getAccessPointId();
            }
            case 1: {
                return configuration.getRemoteAddress();
            }
            case 2: {
                return configuration.getServerConfiguration() instanceof StandaloneThinAccessPointWebServerConfiguration ? Integer.valueOf(((StandaloneThinAccessPointWebServerConfiguration)configuration.getServerConfiguration()).getPort()) : configuration.getServerConfiguration().toString();
            }
            case 3: {
                return configuration.getRemotePort();
            }
            case 4: {
                if (ThinAccessPointTableModel.isUdp(configuration.getAccessPointId())) {
                    return this.udpModel.getAccessPoint(configuration.getAccessPointId()) != null ? ControllerStatus.RUNNING : ControllerStatus.NOT_RUNNING;
                }
                return this.tcpModel.getAccessPoint(configuration.getAccessPointId()) != null ? ControllerStatus.RUNNING : ControllerStatus.NOT_RUNNING;
            }
        }
        return null;
    }

    public ThinAccessPointConfiguration getConfiguration(String accessPointAddress) {
        for (ThinAccessPointConfiguration config : this.configs) {
            if (!config.getRemoteAddress().equals(accessPointAddress)) continue;
            return config;
        }
        return null;
    }

    public void addConfiguration(ThinAccessPointConfiguration configuration) throws DuplicateEntryException {
        this.checkDuplicates(configuration);
        this.configs.add(configuration);
        this.fireTableRowsInserted(this.configs.size() - 1, this.configs.size() - 1);
    }

    private void checkDuplicates(ThinAccessPointConfiguration configuration) throws DuplicateEntryException {
        for (ThinAccessPointConfiguration config : this.configs) {
            if (config.getAccessPointId() != configuration.getAccessPointId() && !config.getRemoteAddress().equals(configuration.getRemoteAddress())) continue;
            throw new DuplicateEntryException("Cannot add/update entry. ID or address already in list");
        }
    }

    private void checkDuplicates(ThinAccessPointConfiguration configuration, int index) throws DuplicateEntryException {
        for (ThinAccessPointConfiguration config : this.configs) {
            if (this.configs.indexOf(config) == index || config.getAccessPointId() != configuration.getAccessPointId() && !config.getRemoteAddress().equals(configuration.getRemoteAddress())) continue;
            throw new DuplicateEntryException("Cannot add/update entry. ID or address already in list");
        }
    }

    public ThinAccessPointConfiguration getConfiguration(int modelIndex) {
        return this.configs.get(modelIndex);
    }

    public boolean isRunning(int index) {
        int apId = this.configs.get(index).getAccessPointId();
        return ThinAccessPointTableModel.isUdp(apId) ? this.udpModel.getAccessPoint(apId) != null : this.tcpModel.getAccessPoint(apId) != null;
    }

    public void removeConfiguration(ThinAccessPointConfiguration configuration) {
        this.configs.remove(configuration);
    }

    public List<ThinAccessPointConfiguration> getConfigurations() {
        return new ArrayList<ThinAccessPointConfiguration>(this.configs);
    }

    public void updateConfiguration(ThinAccessPointConfiguration newConfig, int index) throws DuplicateEntryException {
        if (index >= 0 && index < this.configs.size()) {
            this.checkDuplicates(newConfig, index);
            this.configs.set(index, newConfig);
        }
    }

    public static boolean isUdp(int apId) {
        return AccessPointTypeMapping.getType((int)apId).isUdp();
    }
}

