/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller;

import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointWebServerConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ThinAccessPointConfiguration {
    private final int accessPointId;
    private final String remoteAddress;
    private final int remotePort;
    private InetAddress inetAddress;
    private final ThinAccessPointWebServerConfiguration serverConfiguration;
    private final boolean permanentlyOffline;

    public ThinAccessPointConfiguration(int accessPointId, ThinAccessPointWebServerConfiguration serverConfiguration, String remoteAddress, int remotePort, boolean permanentylOffline) throws InitializationException {
        this.accessPointId = accessPointId;
        this.serverConfiguration = serverConfiguration;
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
        this.permanentlyOffline = permanentylOffline;
        try {
            this.resolveInetAddress();
        }
        catch (UnknownHostException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public void resolveInetAddress() throws UnknownHostException {
        this.inetAddress = InetAddress.getByName(this.remoteAddress);
    }

    public int getAccessPointId() {
        return this.accessPointId;
    }

    public ThinAccessPointWebServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public boolean isPermanentlyOffline() {
        return this.permanentlyOffline;
    }

    public String toString() {
        return String.format("[%s] id: %d, server: %s, address: %s, udp: %d", this.getClass().getSimpleName(), this.accessPointId, this.serverConfiguration.toString(), this.remoteAddress, this.remotePort);
    }
}

