/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller;

import at.mrdevelopment.esl.accesspoint.controller.AccessPointControllerConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointControllerGUI;
import at.mrdevelopment.esl.gui.editor.HostEditor;
import at.mrdevelopment.esl.gui.editor.IntegerEditor;
import at.mrdevelopment.esl.gui.editor.PortEditor;
import at.mrdevelopment.toolkit.gui.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class ControllerConfigurationDialog {
    private JDialog dialog;
    private PortEditor portEditor;
    private IntegerEditor idEditor;
    private HostEditor editor;
    private final JFrame frame;
    private final AccessPointControllerGUI accessPointControllerGUI;
    private AccessPointControllerConfiguration currentConfiguration;
    private int currentIndex;

    public ControllerConfigurationDialog(JFrame frame, AccessPointControllerGUI accessPointControllerGUI) {
        this.frame = frame;
        this.accessPointControllerGUI = accessPointControllerGUI;
        this.initDialog();
    }

    private void initDialog() {
        this.dialog = new JDialog(this.frame, "Add Configuration", true);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ControllerConfigurationDialog.this.onCancelDialog();
            }
        });
        JPanel mainPanel = new JPanel(new SpringLayout());
        mainPanel.add(new JLabel("AP ID:"));
        this.idEditor = new IntegerEditor();
        this.idEditor.setCanBeNull(false);
        mainPanel.add(this.idEditor.getEditorComponent());
        mainPanel.add(new JLabel("Address:"));
        this.editor = new HostEditor();
        this.editor.setCanBeNull(false);
        mainPanel.add(this.editor.getEditorComponent());
        this.portEditor = new PortEditor();
        this.portEditor.setCanBeNull(false);
        mainPanel.add(new JLabel("UDP/TCP port:"));
        mainPanel.add(this.portEditor.getEditorComponent());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        SpringUtilities.makeCompactGrid((Container)mainPanel, (int)3, (int)2, (int)5, (int)5, (int)5, (int)5);
        this.dialog.add((Component)mainPanel, "North");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControllerConfigurationDialog.this.editor.validate();
                ControllerConfigurationDialog.this.portEditor.validate();
                ControllerConfigurationDialog.this.idEditor.validate();
                if (!(ControllerConfigurationDialog.this.editor.hasErrors() || ControllerConfigurationDialog.this.portEditor.hasErrors() || ControllerConfigurationDialog.this.idEditor.hasErrors())) {
                    String address = ControllerConfigurationDialog.this.editor.getValue();
                    if (ControllerConfigurationDialog.this.currentConfiguration == null) {
                        ControllerConfigurationDialog.this.accessPointControllerGUI.addConfiguration(new AccessPointControllerConfiguration(ControllerConfigurationDialog.this.idEditor.getValue(), address, ControllerConfigurationDialog.this.portEditor.getValue()));
                    } else {
                        ControllerConfigurationDialog.this.accessPointControllerGUI.updateConfiguration(new AccessPointControllerConfiguration(ControllerConfigurationDialog.this.idEditor.getValue(), address, ControllerConfigurationDialog.this.portEditor.getValue()), ControllerConfigurationDialog.this.currentIndex);
                    }
                    ControllerConfigurationDialog.this.onCancelDialog();
                }
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControllerConfigurationDialog.this.onCancelDialog();
            }
        });
        buttonPanel.add(cancelButton);
        this.dialog.add((Component)buttonPanel, "South");
        this.dialog.setPreferredSize(new Dimension(300, 200));
        this.dialog.setResizable(false);
        this.dialog.getRootPane().setDefaultButton(okButton);
        this.registerEscapeKeyAction();
        this.dialog.pack();
        this.dialog.setVisible(false);
    }

    protected void onCancelDialog() {
        this.clearFields();
        this.dialog.setVisible(false);
    }

    private void clearFields() {
        this.editor.clear();
        this.portEditor.clear();
        this.idEditor.clear();
    }

    public void showDialog(AccessPointControllerConfiguration configuration, int index) {
        this.currentConfiguration = configuration;
        this.currentIndex = index;
        if (this.currentConfiguration == null) {
            this.clearFields();
        } else {
            this.updateFields(this.currentConfiguration);
        }
        this.dialog.setLocationRelativeTo(this.frame);
        this.idEditor.getEditorComponent().requestFocus();
        this.dialog.setVisible(true);
    }

    private void updateFields(final AccessPointControllerConfiguration configuration) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ControllerConfigurationDialog.this.idEditor.setValue((Object)configuration.getAccessPointId());
                ControllerConfigurationDialog.this.portEditor.setValue((Object)configuration.getPort());
                ControllerConfigurationDialog.this.editor.setValue((Object)configuration.getAddress());
            }
        });
    }

    private void registerEscapeKeyAction() {
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControllerConfigurationDialog.this.onCancelDialog();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }
}

