/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller;

import at.mrdevelopment.esl.accesspoint.controller.AccessPointControllerConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.StandaloneThinAccessPointWebServerConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.xml.AccessPointControllerConfigurationXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;

public class ConfigurationLoader {
    static ESLLogger logger = ESLLogger.getLogger(ConfigurationLoader.class);
    private final int initialPort;
    private final AccessPointControllerConfigurationXMLSerializer serializer;

    public ConfigurationLoader(int initialPort) throws InitializationException {
        this.initialPort = initialPort;
        this.serializer = new AccessPointControllerConfigurationXMLSerializer();
    }

    public List<ThinAccessPointConfiguration> loadConfigurationsFromFiles(List<String> configs) {
        ArrayList<ThinAccessPointConfiguration> totalConfigurations = new ArrayList<ThinAccessPointConfiguration>();
        if (configs != null && !configs.isEmpty()) {
            LinkedHashSet<String> temp = new LinkedHashSet<String>(configs);
            ArrayList<String> configurationFiles = new ArrayList<String>(temp);
            for (String configFile : configurationFiles) {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(configFile);
                    Collection<AccessPointControllerConfiguration> configurations = this.serializer.parseConfigurations(inputStream);
                    totalConfigurations.addAll(this.createConfigurations(configurations));
                }
                catch (Exception exc) {
                    StreamUtils.close(inputStream);
                    logger.warn("Error loading config file %s", new Object[]{configs});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
            }
        }
        return totalConfigurations;
    }

    public List<ThinAccessPointConfiguration> createConfigurations(Collection<AccessPointControllerConfiguration> configurations) {
        int index = 0;
        ArrayList<ThinAccessPointConfiguration> configs = new ArrayList<ThinAccessPointConfiguration>();
        ArrayList<AccessPointControllerConfiguration> list = new ArrayList<AccessPointControllerConfiguration>(configurations);
        Collections.sort(list, new Comparator<AccessPointControllerConfiguration>(){

            @Override
            public int compare(AccessPointControllerConfiguration o1, AccessPointControllerConfiguration o2) {
                return o1.getAccessPointId() - o2.getAccessPointId();
            }
        });
        for (AccessPointControllerConfiguration configuration : list) {
            try {
                int port = this.initialPort + index;
                int udpPort = configuration.getPort();
                ThinAccessPointConfiguration newConfig = new ThinAccessPointConfiguration(configuration.getAccessPointId(), new StandaloneThinAccessPointWebServerConfiguration(port), configuration.getAddress(), udpPort, false);
                configs.add(newConfig);
                ++index;
                logger.debug("Created new access point: %s", new Object[]{newConfig.toString()});
            }
            catch (InitializationException exc) {
                logger.warn("Could not create configuration: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
        return configs;
    }
}

