/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller;

import at.mrdevelopment.esl.accesspoint.AccessPointIF;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointModel;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ReloadRunner;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.util.Collection;

public abstract class BaseAPDispatcher<AP extends AccessPointIF>
implements PeriodicTasksExecutor {
    private static ESLLogger logger = ESLLogger.getLogger(BaseAPDispatcher.class);
    protected static final int COMMUNICATION_TIMEOUT_SECONDS = 120;
    protected final AccessPointModel<AP> model;
    private Shutdownable reloadThread;

    public BaseAPDispatcher(AccessPointModel<AP> model) {
        this.model = model;
    }

    protected void start() {
        this.reloadThread = ReloadRunner.startInBackground((ReloadRunner)new ReloadRunner(this){

            protected long getReloadTime() {
                return 5000L;
            }
        }, (boolean)false);
    }

    protected abstract void periodicInitialization();

    protected abstract void innerShutdown();

    protected abstract void createClientsIfNotPresentFor(Collection<ThinAccessPointConfiguration> var1);

    protected abstract void removeClientsWithNoConfigIn(Collection<ThinAccessPointConfiguration> var1);

    protected abstract void sendInitMessage(ThinAccessPointConfiguration var1) throws IOException;

    public void shutdown() {
        this.reloadThread.shutdown();
        this.innerShutdown();
    }

    public void performPeriodicTasks() throws InterruptedException {
        Collection<ThinAccessPointConfiguration> runningConfigurations = this.model.getRunningConfigurations();
        this.periodicInitialization();
        this.createClientsIfNotPresentFor(runningConfigurations);
        this.removeClientsWithNoConfigIn(runningConfigurations);
        for (ThinAccessPointConfiguration configuration : runningConfigurations) {
            this.checkConnectionStatus(configuration);
            if (!this.shouldSendInitMessage(configuration)) continue;
            try {
                this.sendInitMessage(configuration);
            }
            catch (IOException exc) {
                logger.warn("Could not send init message to %s", new Object[]{configuration.getRemoteAddress()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
    }

    protected abstract void checkConnectionStatus(ThinAccessPointConfiguration var1);

    protected abstract boolean shouldSendInitMessage(ThinAccessPointConfiguration var1);

    public boolean isFinished() {
        return false;
    }
}

