/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller;

import at.mrdevelopment.esl.accesspoint.AccessPointIF;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccessPointModel<AP extends AccessPointIF> {
    protected final Map<Integer, AP> accessPoints = new HashMap<Integer, AP>();

    public List<Integer> getAccessPointKeys() {
        return new ArrayList<Integer>(this.accessPoints.keySet());
    }

    public boolean isRunning(ThinAccessPointConfiguration configuration) {
        return this.accessPoints.containsKey(configuration.getAccessPointId());
    }

    public boolean isRunning(Integer key) {
        return this.accessPoints.containsKey(key);
    }

    public ThinAccessPointConfiguration getConfiguration(Integer key) {
        return ((AccessPointIF)this.accessPoints.get(key)).getConfiguration();
    }

    public AP getAccessPoint(Integer key) {
        return (AP)((AccessPointIF)this.accessPoints.get(key));
    }

    public void removeAccessPoint(Integer key) {
        this.accessPoints.remove(key);
    }

    public void addAccessPoint(Integer key, AP accessPoint) {
        if (!this.isRunning(key)) {
            this.accessPoints.put(key, accessPoint);
        }
    }

    public Collection<ThinAccessPointConfiguration> getRunningConfigurations() {
        ArrayList<ThinAccessPointConfiguration> configurations = new ArrayList<ThinAccessPointConfiguration>();
        for (AccessPointIF accessPoint : this.accessPoints.values()) {
            if (!accessPoint.isRunning()) continue;
            configurations.add(accessPoint.getConfiguration());
        }
        return configurations;
    }

    public AP getAccessPoint(ThinAccessPointConfiguration configuration) {
        return (AP)((AccessPointIF)this.accessPoints.get(configuration.getAccessPointId()));
    }

    public Collection<AP> getAccessPoints() {
        return this.accessPoints.values();
    }
}

