/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller;

import at.mrdevelopment.esl.accesspoint.controller.AccessPointController;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointControllerConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.ConfigurationLoader;
import at.mrdevelopment.esl.accesspoint.controller.ControllerConfigurationDialog;
import at.mrdevelopment.esl.accesspoint.controller.ControllerStatus;
import at.mrdevelopment.esl.accesspoint.controller.DuplicateEntryException;
import at.mrdevelopment.esl.accesspoint.controller.StandaloneThinAccessPointWebServerConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointTableModel;
import at.mrdevelopment.esl.accesspoint.controller.tcp.TCPAccessPointController;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPAccessPointController;
import at.mrdevelopment.esl.accesspoint.controller.xml.AccessPointControllerConfigurationXMLSerializer;
import at.mrdevelopment.esl.gui.AboutDialog;
import at.mrdevelopment.esl.gui.ESLFrame;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.http.XMLContentProducer;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.io.FilenameUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;

public class AccessPointControllerGUI {
    static ESLLogger logger;
    private static final int INITIAL_PORT = 8080;
    private ESLFrame frame;
    private JButton loadButton;
    private JButton startButton;
    private JButton stopButton;
    private ThinAccessPointTableModel tableModel;
    private JTable table;
    private final UDPAccessPointController udpController;
    private final TCPAccessPointController tcpController;
    private JFileChooser fileChooser;
    private final AccessPointControllerConfigurationXMLSerializer serializer;
    private JToolBar toolBar;
    private final Transformer transformer;
    private boolean modified = false;
    private final ControllerConfigurationDialog dialog;
    private List<Integer> usedPorts = new ArrayList<Integer>();
    private File configurationFile;
    private JButton removeButton;
    private JButton editButton;

    public AccessPointControllerGUI(UDPAccessPointController udpController, TCPAccessPointController tcpController, List<String> configs) throws InitializationException {
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (TransformerConfigurationException exc) {
            throw new InitializationException((Throwable)exc);
        }
        this.serializer = new AccessPointControllerConfigurationXMLSerializer();
        this.udpController = udpController;
        this.tcpController = tcpController;
        GUIUtils.setSystemLookAndFeel();
        this.frame = new ESLFrame(IconUtils.loadApplicationIcons((String)"AccessPointControllerGUI"));
        this.frame.setTitle("SES-imagotag Access Point Controller");
        this.frame.setLayout((LayoutManager)new BorderLayout());
        this.frame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                AccessPointControllerGUI.this.onFrameClose();
            }
        });
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        JButton addButton = new JButton(IconUtils.loadIcon((String)"NewRecordAction"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPointControllerGUI.this.onAddButton();
            }
        });
        addButton.setFocusable(false);
        this.toolBar.add(addButton);
        this.editButton = new JButton(IconUtils.loadIcon((String)"EditRecordsAction"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPointControllerGUI.this.onEditButton();
            }
        });
        this.editButton.setFocusable(false);
        this.editButton.setEnabled(false);
        this.toolBar.add(this.editButton);
        this.removeButton = new JButton(IconUtils.loadIcon((String)"DeleteRecordsAction"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPointControllerGUI.this.onRemoveButton();
            }
        });
        this.removeButton.setFocusable(false);
        this.removeButton.setEnabled(false);
        this.toolBar.add(this.removeButton);
        JButton aboutButton = new JButton("About");
        aboutButton.setFocusable(false);
        aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Info info = Info.load(AccessPointController.class);
                    new AboutDialog((JFrame)AccessPointControllerGUI.this.frame, "SES-imagotag Access Point Controller", info.getVersion());
                }
                catch (Exception exc) {
                    logger.warn("Error loading about dialog (%s)", new Object[]{exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
            }
        });
        this.toolBar.add(aboutButton);
        this.frame.add((Component)this.toolBar, (Object)"North");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.loadButton = new JButton("Load Configuration..");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPointControllerGUI.this.onLoadButton();
            }
        });
        buttonPanel.add(this.loadButton);
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPointControllerGUI.this.onSaveButton();
            }
        });
        buttonPanel.add(saveButton);
        JButton saveAsButton = new JButton("Save as..");
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPointControllerGUI.this.onSaveAsButton();
            }
        });
        buttonPanel.add(saveAsButton);
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPointControllerGUI.this.onStartButton();
            }
        });
        buttonPanel.add(this.startButton);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPointControllerGUI.this.onStopButton();
            }
        });
        buttonPanel.add(this.stopButton);
        bottomPanel.add((Component)buttonPanel, "Center");
        this.frame.add((Component)bottomPanel, (Object)"South");
        JPanel mainPanel = new JPanel(new BorderLayout());
        ConfigurationLoader configurationLoader = new ConfigurationLoader(8080);
        List<ThinAccessPointConfiguration> configurations = configurationLoader.loadConfigurationsFromFiles(configs);
        for (ThinAccessPointConfiguration configuration : configurations) {
            this.usedPorts.add(configuration.getRemotePort());
        }
        this.tableModel = new ThinAccessPointTableModel(udpController.getModel(), tcpController.getModel(), configurations);
        this.table = new JTable(this.tableModel);
        this.table.setDefaultRenderer(ControllerStatus.class, new ControllerStatusCellRenderer());
        this.table.setAutoCreateRowSorter(true);
        this.table.setFillsViewportHeight(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AccessPointControllerGUI.this.updateButtons();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    Point p = e.getPoint();
                    int rowNumber = AccessPointControllerGUI.this.table.rowAtPoint(p);
                    if (rowNumber >= 0) {
                        rowNumber = AccessPointControllerGUI.this.table.convertRowIndexToModel(rowNumber);
                        AccessPointControllerGUI.this.table.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
                        AccessPointControllerGUI.this.onEditButton();
                    }
                }
            }
        });
        mainPanel.add(new JScrollPane(this.table));
        this.frame.add((Component)mainPanel, (Object)"Center");
        this.fileChooser = new JFileChooser();
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML Files";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || FilenameUtils.isExtension((String)f.getName(), (String)"xml");
            }
        });
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.dialog = new ControllerConfigurationDialog((JFrame)this.frame, this);
        this.frame.setPreferredSize(new Dimension(600, 300));
        this.frame.pack();
        this.frame.setVisible(true);
    }

    protected void updateButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AccessPointControllerGUI.this.table.getSelectedRowCount() == 0) {
                    AccessPointControllerGUI.this.startButton.setEnabled(false);
                    AccessPointControllerGUI.this.stopButton.setEnabled(false);
                    AccessPointControllerGUI.this.editButton.setEnabled(false);
                    AccessPointControllerGUI.this.removeButton.setEnabled(false);
                } else {
                    int[] selectedRows;
                    AccessPointControllerGUI.this.startButton.setEnabled(false);
                    AccessPointControllerGUI.this.stopButton.setEnabled(false);
                    AccessPointControllerGUI.this.editButton.setEnabled(false);
                    AccessPointControllerGUI.this.removeButton.setEnabled(false);
                    for (int index : selectedRows = AccessPointControllerGUI.this.table.getSelectedRows()) {
                        if (index < 0 || AccessPointControllerGUI.this.tableModel.getRowCount() <= 0) continue;
                        int modelIndex = AccessPointControllerGUI.this.table.convertRowIndexToModel(index);
                        if (AccessPointControllerGUI.this.tableModel.isRunning(modelIndex)) {
                            AccessPointControllerGUI.this.stopButton.setEnabled(true);
                            continue;
                        }
                        AccessPointControllerGUI.this.startButton.setEnabled(true);
                        AccessPointControllerGUI.this.editButton.setEnabled(true);
                        AccessPointControllerGUI.this.removeButton.setEnabled(true);
                    }
                }
            }
        });
    }

    protected void onEditButton() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            int convertedIndex = this.table.convertRowIndexToModel(selectedRow);
            ThinAccessPointConfiguration configuration = this.tableModel.getConfiguration(convertedIndex);
            if (ThinAccessPointTableModel.isUdp(configuration.getAccessPointId())) {
                if (!this.udpController.getModel().isRunning(configuration.getAccessPointId())) {
                    AccessPointControllerConfiguration config = new AccessPointControllerConfiguration(configuration.getAccessPointId(), configuration.getRemoteAddress(), configuration.getRemotePort());
                    this.dialog.showDialog(config, convertedIndex);
                } else {
                    this.showWarning("Running configuration", "Stop entry before editing");
                }
            } else if (!this.tcpController.getModel().isRunning(configuration.getAccessPointId())) {
                AccessPointControllerConfiguration config = new AccessPointControllerConfiguration(configuration.getAccessPointId(), configuration.getRemoteAddress(), configuration.getRemotePort());
                this.dialog.showDialog(config, convertedIndex);
            } else {
                this.showWarning("Running configuration", "Stop entry before editing");
            }
        }
    }

    protected void onRemoveButton() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<ThinAccessPointConfiguration> configurations = new ArrayList<ThinAccessPointConfiguration>();
        for (int selectedRow : selectedRows) {
            ThinAccessPointConfiguration configuration = this.tableModel.getConfiguration(this.table.convertRowIndexToModel(selectedRow));
            if (ThinAccessPointTableModel.isUdp(configuration.getAccessPointId())) {
                if (this.udpController.getModel().isRunning(configuration.getAccessPointId())) {
                    this.showWarning("Still running", String.format("Please stop access point with address %s before removing", configuration.getRemoteAddress()));
                    return;
                }
            } else if (this.tcpController.getModel().isRunning(configuration.getAccessPointId())) {
                this.showWarning("Still running", String.format("Please stop access point with address %s before removing", configuration.getRemoteAddress()));
                return;
            }
            configurations.add(configuration);
        }
        for (ThinAccessPointConfiguration configuration : configurations) {
            this.usedPorts.remove(new Integer(((StandaloneThinAccessPointWebServerConfiguration)configuration.getServerConfiguration()).getPort()));
            this.tableModel.removeConfiguration(configuration);
        }
        this.modified = selectedRows.length > 0;
        this.table.repaint();
        this.updateButtons();
    }

    protected void onAddButton() {
        this.dialog.showDialog(null, -1);
        this.updateButtons();
    }

    protected void onStopButton() {
        int[] indices;
        for (int index : indices = this.table.getSelectedRows()) {
            int modelIndex = this.table.convertRowIndexToModel(index);
            ThinAccessPointConfiguration configuration = this.tableModel.getConfiguration(modelIndex);
            if (ThinAccessPointTableModel.isUdp(configuration.getAccessPointId())) {
                if (!this.udpController.getModel().isRunning(configuration.getAccessPointId())) continue;
                this.udpController.removeAccessPoint(configuration);
                continue;
            }
            if (!this.tcpController.getModel().isRunning(configuration.getAccessPointId())) continue;
            this.tcpController.removeAccessPoint(configuration);
        }
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(true);
        this.table.repaint();
    }

    protected void onStartButton() {
        int[] indices;
        for (int index : indices = this.table.getSelectedRows()) {
            int modelIndex = this.table.convertRowIndexToModel(index);
            if (index == -1) {
                return;
            }
            ThinAccessPointConfiguration configuration = this.tableModel.getConfiguration(modelIndex);
            if (ThinAccessPointTableModel.isUdp(configuration.getAccessPointId())) {
                if (this.udpController.getModel().isRunning(configuration.getAccessPointId())) continue;
                try {
                    this.udpController.addAccessPoint(configuration);
                }
                catch (InitializationException exc) {
                    logger.warn("Could not start access point instance: %s", new Object[]{exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
                continue;
            }
            if (this.tcpController.getModel().isRunning(configuration.getAccessPointId())) continue;
            try {
                this.tcpController.addAccessPoint(configuration);
            }
            catch (InitializationException exc) {
                logger.warn("Could not start access point instance: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
        this.stopButton.setEnabled(true);
        this.startButton.setEnabled(false);
        this.table.repaint();
    }

    /*
     * Exception decompiling
     */
    protected void onLoadButton() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void onFrameClose() {
        if (this.checkModified() != 2) {
            this.udpController.shutdown();
            this.tcpController.shutdown();
            System.exit(0);
        }
    }

    public void updateConfiguration(AccessPointControllerConfiguration accessPointControllerConfiguration, int index) {
        this.modified = true;
        ThinAccessPointConfiguration configuration = this.tableModel.getConfiguration(index);
        if (configuration != null) {
            try {
                ThinAccessPointConfiguration newConfig = new ThinAccessPointConfiguration(accessPointControllerConfiguration.getAccessPointId(), configuration.getServerConfiguration(), accessPointControllerConfiguration.getAddress(), accessPointControllerConfiguration.getPort(), false);
                this.tableModel.updateConfiguration(newConfig, index);
                this.table.repaint();
            }
            catch (InitializationException exc) {
                logger.warn("Could not create configuration for access point %d: %s", new Object[]{accessPointControllerConfiguration.getAccessPointId(), exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                this.showWarning("Could not update configuration", exc.getMessage());
            }
            catch (DuplicateEntryException exc) {
                logger.warn(exc.getMessage());
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                this.showWarning("Could not update configuration", exc.getMessage());
            }
        }
    }

    public void addConfiguration(AccessPointControllerConfiguration accessPointControllerConfiguration) {
        this.modified = true;
        if (this.tableModel.getConfiguration(accessPointControllerConfiguration.getAddress()) != null) {
            this.showWarning("Already in list", String.format("Configuration with address %s already in list.", accessPointControllerConfiguration.getAddress()));
            return;
        }
        int port = 0;
        for (int index = 8080; index <= 8080 + this.tableModel.getRowCount(); ++index) {
            if (this.usedPorts.contains(index)) continue;
            port = index;
            this.usedPorts.add(port);
            break;
        }
        try {
            ThinAccessPointConfiguration newConfig = new ThinAccessPointConfiguration(accessPointControllerConfiguration.getAccessPointId(), new StandaloneThinAccessPointWebServerConfiguration(port), accessPointControllerConfiguration.getAddress(), accessPointControllerConfiguration.getPort(), false);
            this.tableModel.addConfiguration(newConfig);
        }
        catch (InitializationException exc) {
            logger.warn("Could not create configuration for access point %d: %s", new Object[]{accessPointControllerConfiguration.getAccessPointId(), exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        catch (DuplicateEntryException exc) {
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            this.showWarning("Could not create configuration", exc.getMessage());
        }
    }

    private void showWarning(String title, String message) {
        JOptionPane.showMessageDialog((Component)this.frame, message, title, 2);
    }

    protected void onSaveButton() {
        if (this.tableModel.getRowCount() > 0) {
            if (this.configurationFile != null) {
                Collection configurations = Collections2.transform(this.tableModel.getConfigurations(), (Function)new Function<ThinAccessPointConfiguration, AccessPointControllerConfiguration>(){

                    public AccessPointControllerConfiguration apply(ThinAccessPointConfiguration config) {
                        return new AccessPointControllerConfiguration(config.getAccessPointId(), config.getRemoteAddress(), config.getRemotePort());
                    }
                });
                Document document = this.serializer.toXML(configurations);
                try {
                    this.writeDocument(this.configurationFile, document);
                    this.modified = false;
                }
                catch (IOException exc) {
                    logger.warn("Could not save configuration file (%s)", new Object[]{this.configurationFile.getName()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                    JOptionPane.showMessageDialog((Component)this.frame, exc.getMessage(), "Could not save configuration", 0);
                }
                catch (SerializeException exc) {
                    logger.warn("Could not save configuration file (%s)", new Object[]{this.configurationFile.getName()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                    JOptionPane.showMessageDialog((Component)this.frame, exc.getMessage(), "Could not save configuration", 0);
                }
            } else {
                this.onSaveAsButton();
            }
        }
    }

    protected void onSaveAsButton() {
        this.saveAs();
    }

    private int saveAs() {
        if (this.tableModel.getRowCount() > 0) {
            this.fileChooser.setSelectedFile(new File(""));
            int returnValue = 0;
            if (this.fileChooser.showSaveDialog((Component)this.frame) == 0) {
                if (this.fileChooser.getSelectedFile().exists()) {
                    returnValue = JOptionPane.showConfirmDialog((Component)this.frame, "The file already exists. Do you want to overwrite the file?");
                }
                if (returnValue == 0) {
                    this.configurationFile = this.fileChooser.getSelectedFile();
                    if (!FilenameUtils.isExtension((String)this.configurationFile.getName(), (String)"xml")) {
                        this.configurationFile = new File(this.configurationFile.getAbsolutePath() + ".xml");
                    }
                    if (this.configurationFile != null) {
                        this.onSaveButton();
                    }
                }
                return returnValue;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(File destinationFile, Document document) throws IOException, SerializeException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(destinationFile);
            XMLContentProducer contentProducer = new XMLContentProducer(document, this.transformer, null);
            contentProducer.writeTo((OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close((OutputStream)outputStream);
    }

    private int checkModified() {
        int returnValue = 0;
        if (this.modified && (returnValue = JOptionPane.showConfirmDialog((Component)this.frame, "The configuration was modified, do you want to save it?")) == 0) {
            if (this.configurationFile != null) {
                this.onSaveButton();
            } else {
                return this.saveAs();
            }
        }
        return returnValue;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger = ESLLogger.getLogger(AccessPointControllerGUI.class);
    }

    class ControllerStatusCellRenderer
    extends DefaultTableCellRenderer {
        private final Color ONLINE_BACKGROUND_COLOR = new Color(91, 255, 91);
        private final Color OFFLINE_BACKGROUND_COLOR = new Color(255, 91, 91);

        ControllerStatusCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            if (value != null) {
                ControllerStatus status = (ControllerStatus)((Object)value);
                this.setText(status.getStatusText());
                this.setHorizontalAlignment(0);
                if (!isSelected) {
                    if (status == ControllerStatus.RUNNING) {
                        this.setForeground(Color.BLACK);
                        this.setBackground(this.ONLINE_BACKGROUND_COLOR);
                    } else if (status == ControllerStatus.NOT_RUNNING) {
                        this.setForeground(Color.WHITE);
                        this.setBackground(this.OFFLINE_BACKGROUND_COLOR);
                    }
                }
            }
            return this;
        }
    }
}

