/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller;

import at.mrdevelopment.esl.accesspoint.controller.AccessPointControllerGUI;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointInfoHolder;
import at.mrdevelopment.esl.accesspoint.controller.ConfigurationLoader;
import at.mrdevelopment.esl.accesspoint.controller.TCPDefaultAPSettings;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointTableModel;
import at.mrdevelopment.esl.accesspoint.controller.tcp.TCPAccessPointController;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPAccessPointController;
import at.mrdevelopment.esl.accesspoint.taskqueue.ImpreciseDateTimeProvider;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.ShutdownableShutdownHook;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.extern.DefaultTCPTLSConfiguration;
import at.mrdevelopment.toolkit.tcp.extern.TCPTLSConfiguration;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class AccessPointController
implements Shutdownable {
    static ESLLogger logger;
    private static final int INITIAL_PORT = 8080;
    public static final byte MAIN_RELEASE = 1;
    public static final byte SUB_RELEASE = 0;
    public static final byte PATCHLEVEL = 2;
    public static final String BRANCH_NAME = "imagotag";
    public static final String APPLICATION_NAME = "SES-imagotag Access Point Controller";
    public static final Version VERSION;
    protected final boolean removeOnShutdown;
    protected final boolean ignoreAccessPointId;
    protected final AccessPointInfoHolder infoHolder;

    public static void main(String[] args) {
        ESLLogger.initLogger((boolean)true);
        try {
            AccessPointController.loadAccessPointController(args);
        }
        catch (IOException exc) {
            exc.printStackTrace();
            System.exit(1);
        }
    }

    public static void stop(String[] args) {
        System.exit(0);
    }

    private static void loadAccessPointController(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optionConfigFile = parser.accepts("config", "Configuration file").withOptionalArg().ofType(String.class);
        OptionSpecBuilder optionNoGui = parser.accepts("nogui", "Disable GUI");
        OptionSpecBuilder optionHelp = parser.accepts("help", "Show this help");
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)optionHelp)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        List configs = options.has((OptionSpec)optionConfigFile) ? options.valuesOf((OptionSpec)optionConfigFile) : null;
        boolean showGui = !options.has((OptionSpec)optionNoGui);
        try {
            ImpreciseDateTimeProvider.createAndStart((int)5);
            UDPAccessPointController udpAccessPointController = new UDPAccessPointController(!showGui, 7353, 7999, null);
            TCPAccessPointController tcpAccessPointController = new TCPAccessPointController(!showGui, new TCPDefaultAPSettings(), (TCPTLSConfiguration)new DefaultTCPTLSConfiguration(null, null));
            if (!showGui) {
                ConfigurationLoader configurationLoader = new ConfigurationLoader(8080);
                List<ThinAccessPointConfiguration> configurations = configurationLoader.loadConfigurationsFromFiles(configs);
                for (ThinAccessPointConfiguration configuration : configurations) {
                    if (ThinAccessPointTableModel.isUdp(configuration.getAccessPointId())) {
                        udpAccessPointController.addAccessPoint(configuration);
                        continue;
                    }
                    tcpAccessPointController.addAccessPoint(configuration);
                }
            } else {
                new AccessPointControllerGUI(udpAccessPointController, tcpAccessPointController, configs);
            }
        }
        catch (InitializationException exc) {
            exc.printStackTrace();
            System.exit(1);
        }
    }

    public AccessPointController(boolean removeOnShutdown, AccessPointInfoHolder infoHolder) throws InitializationException {
        this(removeOnShutdown, false, infoHolder);
    }

    public AccessPointController(boolean removeOnShutdown, boolean ignoreAccessPointId, AccessPointInfoHolder infoHolder) throws InitializationException {
        this.removeOnShutdown = removeOnShutdown;
        this.ignoreAccessPointId = ignoreAccessPointId;
        this.infoHolder = infoHolder;
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownableShutdownHook(new Shutdownable[]{this}));
    }

    protected abstract void initializeModelAndDispatch() throws InitializationException;

    protected abstract void innerShutdown();

    protected abstract void shutdownAccessPoint(Integer var1);

    protected abstract List<Integer> getAccessPointKeys();

    public abstract boolean isRunning(ThinAccessPointConfiguration var1);

    public abstract void addAccessPoint(ThinAccessPointConfiguration var1) throws InitializationException;

    public abstract void removeAccessPoint(ThinAccessPointConfiguration var1);

    public void shutdownAllAccessPoints() {
        logger.info("Shutting down all access points");
        List<Integer> accessPointAddresses = this.getAccessPointKeys();
        for (Integer accessPointAddress : accessPointAddresses) {
            this.shutdownAccessPoint(accessPointAddress);
        }
    }

    public void shutdown() {
        this.shutdownAllAccessPoints();
        this.innerShutdown();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger = ESLLogger.getLogger(AccessPointController.class);
        VERSION = new Version(1, 0, 2, BRANCH_NAME);
    }
}

