/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.accesspoint.DefaultInternalRoamingTable;
import at.mrdevelopment.esl.accesspoint.request.AbortUpdateTaskRequest;
import at.mrdevelopment.esl.accesspoint.request.AddUpdateTasksRequest;
import at.mrdevelopment.esl.accesspoint.request.RemoveUpdateTaskRequest;
import at.mrdevelopment.esl.accesspoint.request.SetRoamingTableRequest;
import at.mrdevelopment.esl.accesspoint.request.WebserviceExecutionRequest;
import at.mrdevelopment.esl.accesspoint.usb.USBAccessPoint;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.core.JoinStatus;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointProtocol;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class USBAccessPointService
implements AccessPointService {
    private final USBAccessPoint accessPoint;
    private DateTime lastAssignedLabelsQueryTime = null;
    private DateTime lastDiscoveredLabelsQueryTime = null;
    private ServiceAddress serviceAddress;

    public USBAccessPointService(ServiceAddress serviceAddress, USBAccessPoint accessPoint) {
        this.serviceAddress = serviceAddress;
        this.accessPoint = accessPoint;
    }

    public void shutdown() {
        this.accessPoint.shutdown();
    }

    public int getAccessPointId() {
        return this.accessPoint.getAccessPointId();
    }

    public ServiceAddress getServiceAddress() {
        return this.serviceAddress;
    }

    public ServiceAddress getSoftwareUpdateServiceAddress() {
        throw new UnsupportedOperationException();
    }

    public void sendConfiguration(AccessPointConfiguration accessPointConfiguration) throws WebserviceException, SerializeException {
        throw new UnsupportedOperationException();
    }

    public void sendRoamingTable(RoamingTable roamingTable) throws WebserviceException, SerializeException {
        DefaultInternalRoamingTable internalRoamingTable = new DefaultInternalRoamingTable(roamingTable, this.getAccessPointId(), "localhost", "localhost");
        this.accessPoint.getRequestQueue().addRequest((WebserviceExecutionRequest)new SetRoamingTableRequest((InternalRoamingTable)internalRoamingTable));
    }

    public void sendSoftwareUpdate(File file) throws WebserviceException {
        throw new UnsupportedOperationException();
    }

    public void queryServiceStatus(AccessPointReplyCallback callback) {
        callback.processServiceStatus((AccessPointService)this, new AccessPointServiceStatus(this.accessPoint.getAccessPointDataListener().getServiceStatus()));
    }

    public void queryAssignedLabels(AccessPointReplyCallback callback) {
        int seconds = this.getSecondsForQuery(this.lastAssignedLabelsQueryTime);
        LinkedList results = this.accessPoint.getAccessPointDataListener().getWakeupStatisticsListener().getLabelsLastSeenWithinSeconds(seconds);
        this.lastAssignedLabelsQueryTime = DateTime.now();
        callback.processWakeupStatistics((Collection)results);
    }

    public void queryDiscoveredLabels(AccessPointReplyCallback callback) {
        int seconds = this.getSecondsForQuery(this.lastDiscoveredLabelsQueryTime);
        LinkedList results = this.accessPoint.getAccessPointDataListener().getWakeupStatisticsListener().getJoinRequestsWithJoinStatus(JoinStatus.ACCEPTED, seconds);
        this.lastDiscoveredLabelsQueryTime = DateTime.now();
        callback.processJoinRequests((Collection)results);
    }

    public void queryUpdateTasks(AccessPointReplyCallback callback) throws DatasetException {
        callback.processUpdateTasks(this.getAccessPointId(), (Collection)this.accessPoint.getAccessPointDataListener().getAllUpdateTasks());
    }

    public void queryLabelEvents(AccessPointReplyCallback callback) {
        callback.processLabelEvents(this.getAccessPointId(), this.accessPoint.getAccessPointDataListener().getWakeupStatisticsListener().getLabelEvents());
    }

    public void sendAbortRequests(List<UUID> tasksToAbort) throws WebserviceException, SerializeException {
        if (!tasksToAbort.isEmpty()) {
            this.accessPoint.getRequestQueue().addRequest((WebserviceExecutionRequest)new AbortUpdateTaskRequest((Collection)Lists.newArrayList(tasksToAbort)));
        }
    }

    public void sendRemoveRequests(List<UUID> tasksToRemove) throws WebserviceException, SerializeException {
        if (!tasksToRemove.isEmpty()) {
            this.accessPoint.getRequestQueue().addRequest((WebserviceExecutionRequest)new RemoveUpdateTaskRequest((Collection)Lists.newArrayList(tasksToRemove)));
        }
    }

    public void sendTasks(List<ExternalUpdateTask> updateTasks) {
        if (!updateTasks.isEmpty()) {
            this.accessPoint.getAccessPoint().prepareTaskImages(updateTasks);
            if (updateTasks.size() > 0) {
                this.accessPoint.getRequestQueue().addUpdateTaskPartionRequests(updateTasks, AddUpdateTasksRequest.class);
            }
        }
    }

    public boolean isTaskTypeSupported(TaskType taskType) {
        return true;
    }

    private int getSecondsForQuery(DateTime time) {
        return time != null ? Seconds.secondsBetween((ReadableInstant)time, (ReadableInstant)DateTime.now()).getSeconds() + 15 : 0;
    }

    public AccessPointProtocol getProtocol() {
        return AccessPointProtocol.USB;
    }

    public void sendInternalRoamingTable(InternalRoamingTable roamingTable) {
        this.accessPoint.getRequestQueue().addRequest((WebserviceExecutionRequest)new SetRoamingTableRequest(roamingTable));
    }
}

