/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.AccessPointCommonDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointIF;
import at.mrdevelopment.esl.accesspoint.AccessPointMSPStatusTask;
import at.mrdevelopment.esl.accesspoint.AccessPointMessageForwarder;
import at.mrdevelopment.esl.accesspoint.AccessPointModule;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointWakeupStatisticsListenerIF;
import at.mrdevelopment.esl.accesspoint.ProtocolSettingsProvider;
import at.mrdevelopment.esl.accesspoint.RequestQueue;
import at.mrdevelopment.esl.accesspoint.SendBroadcastTask;
import at.mrdevelopment.esl.accesspoint.SlotIdReader;
import at.mrdevelopment.esl.accesspoint.SlotIdReaderStrategy;
import at.mrdevelopment.esl.accesspoint.SlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.ThinAccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.ThinAccessPointService;
import at.mrdevelopment.esl.accesspoint.TimeoutLabelEvents;
import at.mrdevelopment.esl.accesspoint.TimeoutUpdateTasks;
import at.mrdevelopment.esl.accesspoint.TimeoutWakeupStatisticsListenerTask;
import at.mrdevelopment.esl.accesspoint.UDPWirelessTransmitter;
import at.mrdevelopment.esl.accesspoint.UpdateRegisteredLabelDocumentTask;
import at.mrdevelopment.esl.accesspoint.UpdateServiceStatusTask;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.UDPBackendControl;
import at.mrdevelopment.esl.accesspoint.controller.UDPConfigurationStorage;
import at.mrdevelopment.esl.accesspoint.controller.UDPSystemAttributes;
import at.mrdevelopment.esl.accesspoint.http.AccessPointHttpServer;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointMode;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointThinMode;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AutoConfiguration;
import at.mrdevelopment.esl.admin.platform.config.control.AccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.admin.platform.config.storage.ConfigurationStorage;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.DefaultPeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.esl.core.UpdateTaskQueueListener;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.accesspoint.AccessPointProtocol;
import at.mrdevelopment.toolkit.FirmwareVersionProvider;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.ShutdownableShutdownHook;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.BasicHttpServer;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.util.HashSet;
import java.util.Set;

public class UDPAccessPoint
implements Shutdownable,
AccessPointIF {
    static ESLLogger logger = ESLLogger.getLogger(UDPAccessPoint.class);
    private final ThinAccessPointConfiguration configuration;
    private final UDPConfigurationStorage configurationStorage;
    private final UDPWirelessTransmitter wirelessTransmitter;
    private final AccessPointModule accessPointModule;
    private final Set<Shutdownable> shutdownables = new HashSet<Shutdownable>();
    private final boolean ignoreAccessPointId;
    private final ThinAccessPointDataListener accessPointDataListener;
    private final AccessPointService thinAccessPointService;
    private volatile boolean running = false;
    private boolean receivedFirmwareVersion;

    public UDPAccessPoint(ThinAccessPointConfiguration configuration, AccessPointMessageForwarder forwarder) throws InitializationException {
        this(configuration, forwarder, false);
    }

    public UDPAccessPoint(ThinAccessPointConfiguration configuration, AccessPointMessageForwarder forwarder, boolean ignoreAccessPointId) throws InitializationException {
        this.ignoreAccessPointId = ignoreAccessPointId;
        this.receivedFirmwareVersion = false;
        try {
            this.configuration = configuration;
            this.configurationStorage = new UDPConfigurationStorage(configuration);
            Info info = Info.load(AccessPointIF.class);
            UDPBackendControl backendControl = new UDPBackendControl();
            AccessPointConfigurationManager configurationManager = new AccessPointConfigurationManager((BackendControl)backendControl, (ConfigurationStorage)this.configurationStorage);
            configurationManager.setAutoConfiguration(AutoConfiguration.DISABLED);
            UDPSystemAttributes systemAttributes = new UDPSystemAttributes(configuration.getAccessPointId());
            AccessPointRuntimeConfiguration runtimeConfiguration = new AccessPointRuntimeConfiguration(info, configuration.getRemotePort(), systemAttributes.getDeviceMode(), false, false);
            RequestQueue requestQueue = new RequestQueue();
            AccessPoint accessPoint = new AccessPoint(configurationManager, (AccessPointSystemAttributes)systemAttributes, runtimeConfiguration, requestQueue, true, false);
            this.accessPointDataListener = ThinAccessPointDataListener.createForUDPAccessPoint(accessPoint, configurationManager, systemAttributes, runtimeConfiguration);
            requestQueue.registerUpdateTaskQueueListener((UpdateTaskQueueListener)this.accessPointDataListener.getServiceStatusListener());
            DefaultPeriodicTasksExecutor taskExecutor = new DefaultPeriodicTasksExecutor(){

                public long getReloadTime() {
                    return 10000L;
                }
            };
            taskExecutor.addProcessingTask((ESLProcessingTask)new AccessPointMSPStatusTask((AccessPointCommonDataListener)this.accessPointDataListener, configurationManager));
            taskExecutor.addProcessingTask((ESLProcessingTask)new SendBroadcastTask((AccessPointCommonDataListener)this.accessPointDataListener, configurationManager, (SystemAttributes)systemAttributes, runtimeConfiguration));
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutUpdateTasks((AccessPointDataListener)this.accessPointDataListener, requestQueue));
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutLabelEvents((AccessPointDataListener)this.accessPointDataListener));
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutWakeupStatisticsListenerTask((AccessPointWakeupStatisticsListenerIF)this.accessPointDataListener.getWakeupStatisticsListener()));
            taskExecutor.addProcessingTask((ESLProcessingTask)new UpdateServiceStatusTask((AccessPointCommonDataListener)this.accessPointDataListener));
            taskExecutor.addProcessingTask((ESLProcessingTask)new UpdateRegisteredLabelDocumentTask(this.accessPointDataListener.getServiceStatusListener()));
            AccessPointHttpServer httpServer = new AccessPointHttpServer(accessPoint, AccessPointMode.createOnServer((boolean)true, (AccessPointThinMode)AccessPointThinMode.UDP), (AccessPointCommonDataListener)this.accessPointDataListener, requestQueue, (AccessPointBackendControl)backendControl, configurationManager, (AccessPointSystemAttributes)systemAttributes, runtimeConfiguration, null);
            configuration.getServerConfiguration().startServer((BasicHttpServer)httpServer);
            taskExecutor.start();
            SlotPipeline slotPipeline = new SlotPipeline(16);
            SlotPipelineProcessing slotPipelineProcessing = new SlotPipelineProcessing(accessPoint, slotPipeline);
            slotPipelineProcessing.startProcessingThread();
            Runtime.getRuntime().addShutdownHook((Thread)new ShutdownableShutdownHook(new Shutdownable[]{slotPipelineProcessing}));
            this.wirelessTransmitter = new UDPWirelessTransmitter(slotPipeline, slotPipelineProcessing, (ProtocolSettingsProvider)accessPoint, configuration.getAccessPointId(), forwarder, (SlotIdReader)new SlotIdReaderStrategy((FirmwareVersionProvider)accessPoint));
            this.accessPointModule = new AccessPointModule(slotPipeline, accessPoint, (PeriodicTasksExecutor)taskExecutor, httpServer);
            this.shutdownables.add((Shutdownable)this.wirelessTransmitter);
            this.shutdownables.add((Shutdownable)this.accessPointModule);
            this.shutdownables.add((Shutdownable)slotPipelineProcessing);
            this.updateInformation(Version.UNDEFINED, this.configurationStorage.getWirelessChannel());
            EnvironmentProperties environmentProperties = new EnvironmentProperties(false);
            this.thinAccessPointService = new ThinAccessPointService(configuration.getServerConfiguration().createServiceAddress(false, environmentProperties.getIPAddress()), null, accessPoint, this.accessPointDataListener, requestQueue, AccessPointProtocol.THIN_UDP);
            this.running = true;
        }
        catch (InitializationException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public void shutdown() {
        for (Shutdownable shutdownable : this.shutdownables) {
            shutdownable.shutdown();
        }
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedMessage(DatagramPacket packet, AccessPointMessageForwarder forwarder, boolean toSend) throws Exception {
        FrameInputStream inputStream;
        block9: {
            inputStream = null;
            try {
                inputStream = new FrameInputStream((InputStream)new ByteArrayInputStream(packet.getData()));
                int length = inputStream.readByte();
                int header = inputStream.readByte();
                if (length == 174) {
                    if (this.receivedFirmwareVersion) {
                        this.wirelessTransmitter.receivedMessage(packet, toSend);
                    } else {
                        logger.info("Received packet (Slot-request) before firmware version was set, ignoring packet.");
                    }
                    break block9;
                }
                if (length == 7 && header == 173) {
                    int accessPointId = inputStream.read32BitWord();
                    Version firmwareVersion = Version.fromByte((int)inputStream.readByte());
                    WirelessChannel channel = WirelessChannel.getFromId((int)inputStream.readByte());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received valid UDP packet from %s", new Object[]{packet.getAddress().toString()});
                        logger.debug("accessPointId = %d", new Object[]{accessPointId});
                        logger.debug("firmwareVersion = %s", new Object[]{firmwareVersion});
                        logger.debug("channel = %s", new Object[]{channel});
                    }
                    if (!this.ignoreAccessPointId && accessPointId != this.configuration.getAccessPointId()) {
                        logger.warn("Received AP-ID does not match configured AP-ID (received: %d, configured: %d)", new Object[]{accessPointId, this.configuration.getAccessPointId()});
                    }
                    if (firmwareVersion != null && channel != null) {
                        this.updateInformation(firmwareVersion, channel);
                        this.receivedFirmwareVersion = true;
                    }
                    break block9;
                }
                logger.warn("Received unexpected UDP packet (length = %d (0x%02X), header = %d (0x%02X)", new Object[]{length, length, header, header});
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close((InputStream)inputStream);
    }

    public int getAccessPointId() {
        return this.configuration.getAccessPointId();
    }

    @Override
    public ThinAccessPointConfiguration getConfiguration() {
        return this.configuration;
    }

    void updateInformation(Version firmwareVersion, WirelessChannel channel) {
        this.accessPointModule.getAccessPoint().setFirmwareVersion(firmwareVersion);
        this.configurationStorage.setWirelessChannel(channel);
    }

    public UDPWirelessTransmitter getUDPWirelessTransmitter() {
        return this.wirelessTransmitter;
    }

    @Override
    public void setConnectionStatus(ConnectionStatus status) {
        this.accessPointDataListener.updateConnectionStatus(status);
    }

    public AccessPointService getAccessPointService() {
        return this.thinAccessPointService;
    }
}

