/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceClient;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.accesspoint.DefaultInternalRoamingTable;
import at.mrdevelopment.esl.accesspoint.RequestQueue;
import at.mrdevelopment.esl.accesspoint.ThinAccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.request.AbortUpdateTaskRequest;
import at.mrdevelopment.esl.accesspoint.request.AddUpdateTasksRequest;
import at.mrdevelopment.esl.accesspoint.request.RemoveUpdateTaskRequest;
import at.mrdevelopment.esl.accesspoint.request.SetRoamingTableRequest;
import at.mrdevelopment.esl.accesspoint.request.WebserviceExecutionRequest;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.JoinStatus;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointProtocol;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.lancom.LancomInfo;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class ThinAccessPointService
implements AccessPointService {
    static ESLLogger logger = ESLLogger.getLogger(ThinAccessPointService.class);
    private final AccessPoint accessPoint;
    private final ThinAccessPointDataListener accessPointDataListener;
    private final RequestQueue requestQueue;
    private final ServiceAddress localServiceAddress;
    private final ServiceAddress remoteServiceAddress;
    private final AccessPointProtocol protocol;
    private final ThickServiceStatusHolder thickServiceStatusHolder;
    private final AccessPointType type;
    private DateTime lastAssignedLabelsQueryTime = null;
    private DateTime lastDiscoveredLabelsQueryTime = null;

    public ThinAccessPointService(ServiceAddress localServiceAddress, ServiceAddress remoteServiceAddress, AccessPoint accessPoint, ThinAccessPointDataListener accessPointDataListener, RequestQueue requestQueue, AccessPointProtocol protocol) throws InitializationException {
        this.localServiceAddress = localServiceAddress;
        this.remoteServiceAddress = remoteServiceAddress;
        this.accessPoint = accessPoint;
        this.accessPointDataListener = accessPointDataListener;
        this.requestQueue = requestQueue;
        this.protocol = protocol;
        this.type = AccessPointTypeMapping.getType((int)accessPoint.getAccessPointId());
        this.thickServiceStatusHolder = new ThickServiceStatusHolder();
    }

    public int getAccessPointId() {
        return this.accessPoint.getAccessPointId();
    }

    public ServiceAddress getServiceAddress() {
        return this.localServiceAddress;
    }

    public ServiceAddress getSoftwareUpdateServiceAddress() {
        return this.remoteServiceAddress;
    }

    public void sendConfiguration(AccessPointConfiguration accessPointConfiguration) throws WebserviceException, SerializeException {
        throw new UnsupportedOperationException();
    }

    public void sendRoamingTable(RoamingTable roamingTable) throws WebserviceException, SerializeException {
        DefaultInternalRoamingTable internalRoamingTable = new DefaultInternalRoamingTable(roamingTable, this.getAccessPointId(), "localhost", "localhost");
        this.requestQueue.addRequest((WebserviceExecutionRequest)new SetRoamingTableRequest((InternalRoamingTable)internalRoamingTable));
    }

    public void sendSoftwareUpdate(File file) throws WebserviceException {
        throw new UnsupportedOperationException();
    }

    public void queryServiceStatus(AccessPointReplyCallback callback) {
        AccessPointServiceStatus accessPointServiceStatus = new AccessPointServiceStatus(this.accessPointDataListener.getServiceStatus());
        if (this.type != AccessPointType.USB_AP && this.remoteServiceAddress != null && this.remoteServiceAddress.isValid()) {
            if (this.type != AccessPointType.LANCOM) {
                try {
                    AccessPointServiceClient httpServiceClient = new AccessPointServiceClient(this.accessPoint.getAccessPointId(), this.remoteServiceAddress, false, false);
                    httpServiceClient.queryServiceStatus((AccessPointReplyCallback)this.thickServiceStatusHolder);
                }
                catch (InitializationException e) {
                    logger.debug("Could not initialize AccessPointServiceClient with remote address %s.", new Object[]{this.remoteServiceAddress});
                }
            }
            if (this.thickServiceStatusHolder.getAccessPointServiceStatus() != null) {
                String apSoftwareVersion = this.thickServiceStatusHolder.getAccessPointServiceStatus().getServiceStatus().getPropertyValue("version");
                logger.debug("Received service status from AP, setting the Software-version to %s.", new Object[]{apSoftwareVersion});
                accessPointServiceStatus.getServiceStatus().setProperty("version", apSoftwareVersion);
                accessPointServiceStatus.getServiceStatus().setProperty("thinap-mode", this.thickServiceStatusHolder.getAccessPointServiceStatus().isThinAPModeEnabled());
                accessPointServiceStatus.getServiceStatus().setProperty("outbound-mode", this.thickServiceStatusHolder.getAccessPointServiceStatus().isOutboundModeEnabled());
                accessPointServiceStatus.getServiceStatus().setProperty("apc-address", this.thickServiceStatusHolder.getAccessPointServiceStatus().getApcAddress());
                accessPointServiceStatus.getServiceStatus().setProperty("apc-port", (long)this.thickServiceStatusHolder.getAccessPointServiceStatus().getApcPort());
            }
        }
        callback.processServiceStatus((AccessPointService)this, accessPointServiceStatus);
    }

    public void queryAssignedLabels(AccessPointReplyCallback callback) {
        int seconds = this.getSecondsForQuery(this.lastAssignedLabelsQueryTime);
        LinkedList results = this.accessPointDataListener.getWakeupStatisticsListener().getLabelsLastSeenWithinSeconds(seconds);
        this.lastAssignedLabelsQueryTime = DateTime.now();
        callback.processWakeupStatistics((Collection)results);
    }

    public void queryDiscoveredLabels(AccessPointReplyCallback callback) {
        int seconds = this.getSecondsForQuery(this.lastDiscoveredLabelsQueryTime);
        LinkedList results = this.accessPointDataListener.getWakeupStatisticsListener().getJoinRequestsWithJoinStatus(JoinStatus.ACCEPTED, seconds);
        this.lastDiscoveredLabelsQueryTime = DateTime.now();
        callback.processJoinRequests((Collection)results);
    }

    public void queryUpdateTasks(AccessPointReplyCallback callback) throws DatasetException {
        callback.processUpdateTasks(this.getAccessPointId(), (Collection)this.accessPointDataListener.getAllUpdateTasks());
    }

    public void queryLabelEvents(AccessPointReplyCallback callback) {
        callback.processLabelEvents(this.getAccessPointId(), this.accessPointDataListener.getWakeupStatisticsListener().getLabelEvents());
    }

    public void sendAbortRequests(List<UUID> tasksToAbort) throws WebserviceException, SerializeException {
        if (!tasksToAbort.isEmpty()) {
            this.requestQueue.addRequest((WebserviceExecutionRequest)new AbortUpdateTaskRequest((Collection)Lists.newArrayList(tasksToAbort)));
        }
    }

    public void sendRemoveRequests(List<UUID> tasksToRemove) throws WebserviceException, SerializeException {
        if (!tasksToRemove.isEmpty()) {
            this.requestQueue.addRequest((WebserviceExecutionRequest)new RemoveUpdateTaskRequest((Collection)Lists.newArrayList(tasksToRemove)));
        }
    }

    public void sendTasks(List<ExternalUpdateTask> updateTasks) {
        if (!updateTasks.isEmpty()) {
            this.accessPoint.prepareTaskImages(updateTasks);
            if (updateTasks.size() > 0) {
                this.requestQueue.addUpdateTaskPartionRequests(updateTasks, AddUpdateTasksRequest.class);
            }
        }
    }

    public boolean isTaskTypeSupported(TaskType taskType) {
        return true;
    }

    public void shutdown() {
    }

    private int getSecondsForQuery(DateTime time) {
        return time != null ? Seconds.secondsBetween((ReadableInstant)time, (ReadableInstant)DateTime.now()).getSeconds() + 15 : 0;
    }

    public void notifyLancomInformation(LancomInfo lancomInfo) {
        this.accessPointDataListener.updateLancomInformation(lancomInfo);
    }

    public AccessPointProtocol getProtocol() {
        return this.protocol;
    }

    public void sendInternalRoamingTable(InternalRoamingTable roamingTable) {
        this.requestQueue.addRequest((WebserviceExecutionRequest)new SetRoamingTableRequest(roamingTable));
    }

    private class ThickServiceStatusHolder
    implements AccessPointReplyCallback {
        private AccessPointServiceStatus accessPointServiceStatus;

        private ThickServiceStatusHolder() {
        }

        public void processServiceStatus(AccessPointService accessPointService, AccessPointServiceStatus serviceStatus) {
            this.accessPointServiceStatus = serviceStatus;
        }

        public void processWakeupStatistics(Collection<WakeupStatistic> receivedWakeupStatistics) {
        }

        public void processJoinRequests(Collection<JoinRequest> joinRequests) {
        }

        public void processUpdateTasks(int accessPointId, Collection<ExternalUpdateTask> receivedUpdateTasks) throws DatasetException {
        }

        public void processLabelEvents(int accessPointId, Collection<LabelEvent> labelEvents) {
        }

        public void failedToQueryAccessPoint(AccessPointService accessPointService) {
        }

        public AccessPointServiceStatus getAccessPointServiceStatus() {
            return this.accessPointServiceStatus;
        }
    }
}

