/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.tcp.SlotChannelHandler;
import at.mrdevelopment.esl.accesspoint.tcp.TCPWirelessTransmitter;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPPacket;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class TCPReplyReceiver
implements Runnable,
Shutdownable,
PacketDestinationStrategy {
    private static final ESLLogger logger = ESLLogger.getLogger(TCPReplyReceiver.class);
    private volatile boolean shutdownRequested = false;
    private volatile boolean shutdownFinished = false;
    private final BlockingQueue<TCPPacket> queue;
    private final TCPWirelessTransmitter transmitter;
    private volatile SlotChannelHandler slotChannelHandler;

    public TCPReplyReceiver(TCPWirelessTransmitter transmitter) {
        this.transmitter = transmitter;
        this.queue = new LinkedBlockingQueue<TCPPacket>(6);
    }

    public void setSlotChannelHandler(SlotChannelHandler slotChannelHandler) {
        this.slotChannelHandler = slotChannelHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdownRequested) {
                try {
                    TCPPacket temp = this.queue.poll(2L, TimeUnit.SECONDS);
                    if (!(temp instanceof ThinAPPacket)) continue;
                    ThinAPPacket packet = (ThinAPPacket)temp;
                    if (packet.getType().isBinary()) {
                        this.transmitter.accept((TCPPacket)packet);
                        continue;
                    }
                    this.slotChannelHandler.accept((TCPPacket)packet);
                }
                catch (InterruptedException e) {
                    logger.logException((Throwable)e);
                }
            }
            return;
        }
        catch (Exception e) {
            logger.logException((Throwable)e);
            return;
        }
        finally {
            this.shutdownFinished = true;
        }
    }

    public void shutdown() {
        this.shutdownRequested = true;
        while (!this.shutdownFinished) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info("TCP-AP receiver terminated, AP-ID: %d.", new Object[]{this.getApId()});
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.setName("TCP AP Receiver - " + this.getApId());
        thread.start();
    }

    public int getApId() {
        return this.transmitter.getApId();
    }

    public void accept(TCPPacket packet) {
        if (!this.queue.offer(packet) && logger.isDebugEnabled()) {
            logger.debug("Could not put packet on queue for AP-ID = %d.", new Object[]{this.getApId()});
        }
    }
}

