/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.AccessPointCommonDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointConnectionManager;
import at.mrdevelopment.esl.accesspoint.AccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointIF;
import at.mrdevelopment.esl.accesspoint.AccessPointMSPStatusTask;
import at.mrdevelopment.esl.accesspoint.AccessPointModule;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.ChannelStatusProvider;
import at.mrdevelopment.esl.accesspoint.DaemonInfoProvider;
import at.mrdevelopment.esl.accesspoint.HttpHandlerDeregistrator;
import at.mrdevelopment.esl.accesspoint.ProtocolSettingsProvider;
import at.mrdevelopment.esl.accesspoint.RequestQueue;
import at.mrdevelopment.esl.accesspoint.SendBroadcastTask;
import at.mrdevelopment.esl.accesspoint.SlotIdReader;
import at.mrdevelopment.esl.accesspoint.SlotIdReaderStrategy;
import at.mrdevelopment.esl.accesspoint.SoftSynchronizer;
import at.mrdevelopment.esl.accesspoint.TCPReplyReceiver;
import at.mrdevelopment.esl.accesspoint.ThinAccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.ThinAccessPointService;
import at.mrdevelopment.esl.accesspoint.TimeoutLabelEvents;
import at.mrdevelopment.esl.accesspoint.TimeoutRoamingTableTask;
import at.mrdevelopment.esl.accesspoint.TimeoutUpdateTasks;
import at.mrdevelopment.esl.accesspoint.UpdateRegisteredLabelDocumentTask;
import at.mrdevelopment.esl.accesspoint.UpdateServiceStatusTask;
import at.mrdevelopment.esl.accesspoint.controller.TCPConfigurationStorage;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.UDPBackendControl;
import at.mrdevelopment.esl.accesspoint.controller.UDPSystemAttributes;
import at.mrdevelopment.esl.accesspoint.controller.tcp.server.APCProviderHolder;
import at.mrdevelopment.esl.accesspoint.http.AccessPointHttpServer;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointMode;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointThinMode;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.esl.accesspoint.tcp.AccessPointSettingsReceiver;
import at.mrdevelopment.esl.accesspoint.tcp.TCPAccessPointSettings;
import at.mrdevelopment.esl.accesspoint.tcp.TCPSlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.tcp.TCPWirelessTransmitter;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.control.AccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.admin.platform.config.storage.ConfigurationStorage;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.DefaultPeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.UpdateTaskQueueListener;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.accesspoint.AccessPointProtocol;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.toolkit.FirmwareVersionProvider;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.BasicHttpServer;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.HashSet;
import java.util.Set;

public class TCPAccessPoint
implements Shutdownable,
AccessPointIF,
AccessPointSettingsReceiver {
    private static final ESLLogger logger = ESLLogger.getLogger(TCPAccessPoint.class);
    private final ThinAccessPointConfiguration configuration;
    private final TCPConfigurationStorage configurationStorage;
    private final AccessPoint accessPoint;
    private volatile TCPReplyReceiver replyReceiver;
    private volatile TCPWirelessTransmitter wirelessTransmitter;
    private volatile TCPSlotPipelineProcessing slotPipelineProcessing;
    private final AccessPointModule accessPointModule;
    private final Set<Shutdownable> shutdownables = new HashSet<Shutdownable>();
    private ThinAccessPointDataListener accessPointDataListener;
    private AccessPointService thinAccessPointService;
    private boolean running = false;
    private APCProviderHolder providerHolder;

    public TCPAccessPoint(AccessPointConnectionManager connectionManager, ThinAccessPointConfiguration configuration, WirelessChannel channel, TCPAccessPointSettings tcpAPSettings) throws InitializationException {
        this.configuration = configuration;
        this.configurationStorage = new TCPConfigurationStorage(configuration);
        try {
            Info info = Info.load(AccessPointIF.class);
            UDPBackendControl backendControl = new UDPBackendControl();
            AccessPointConfigurationManager configurationManager = new AccessPointConfigurationManager((BackendControl)backendControl, (ConfigurationStorage)this.configurationStorage);
            UDPSystemAttributes systemAttributes = new UDPSystemAttributes(configuration.getAccessPointId());
            AccessPointRuntimeConfiguration runtimeConfiguration = new AccessPointRuntimeConfiguration(info, configuration.getRemotePort(), systemAttributes.getDeviceMode(), false, false);
            RequestQueue requestQueue = new RequestQueue();
            this.accessPoint = new AccessPoint(configurationManager, (AccessPointSystemAttributes)systemAttributes, runtimeConfiguration, requestQueue, true, true);
            this.accessPointDataListener = ThinAccessPointDataListener.createForTCPAccessPoint(this.accessPoint, configurationManager, systemAttributes, runtimeConfiguration, tcpAPSettings);
            requestQueue.registerUpdateTaskQueueListener((UpdateTaskQueueListener)this.accessPointDataListener.getServiceStatusListener());
            DefaultPeriodicTasksExecutor taskExecutor = new DefaultPeriodicTasksExecutor(){

                public long getReloadTime() {
                    return 10000L;
                }
            };
            taskExecutor.addProcessingTask((ESLProcessingTask)new AccessPointMSPStatusTask((AccessPointCommonDataListener)this.accessPointDataListener, configurationManager));
            taskExecutor.addProcessingTask((ESLProcessingTask)new SendBroadcastTask((AccessPointCommonDataListener)this.accessPointDataListener, configurationManager, (SystemAttributes)systemAttributes, runtimeConfiguration));
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutUpdateTasks((AccessPointDataListener)this.accessPointDataListener, requestQueue));
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutLabelEvents((AccessPointDataListener)this.accessPointDataListener));
            taskExecutor.addProcessingTask((ESLProcessingTask)new UpdateServiceStatusTask((AccessPointCommonDataListener)this.accessPointDataListener));
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutRoamingTableTask(this.accessPoint));
            taskExecutor.addProcessingTask((ESLProcessingTask)new UpdateRegisteredLabelDocumentTask(this.accessPointDataListener.getServiceStatusListener()));
            AccessPointHttpServer httpServer = new AccessPointHttpServer(this.accessPoint, AccessPointMode.createOnServer((boolean)true, (AccessPointThinMode)AccessPointThinMode.TCP), (AccessPointCommonDataListener)this.accessPointDataListener, requestQueue, (AccessPointBackendControl)backendControl, configurationManager, (AccessPointSystemAttributes)systemAttributes, runtimeConfiguration, null);
            configuration.getServerConfiguration().startServer((BasicHttpServer)httpServer);
            taskExecutor.start();
            SlotPipeline slotPipeline = new SlotPipeline(16);
            SoftSynchronizer softSynchronizer = new SoftSynchronizer(this.accessPoint.getAccessPointId());
            this.slotPipelineProcessing = new TCPSlotPipelineProcessing(this.accessPoint, slotPipeline, softSynchronizer);
            this.slotPipelineProcessing.startProcessingThread();
            this.shutdownables.add((Shutdownable)this.slotPipelineProcessing);
            this.wirelessTransmitter = new TCPWirelessTransmitter(slotPipeline, this.slotPipelineProcessing, softSynchronizer, (ProtocolSettingsProvider)this.accessPoint, configuration.getAccessPointId(), connectionManager, (FirmwareVersionProvider)this.accessPoint, (SlotIdReader)new SlotIdReaderStrategy((FirmwareVersionProvider)this.accessPoint), (AccessPointSettingsReceiver)this);
            this.accessPointModule = new AccessPointModule(slotPipeline, this.accessPoint, (PeriodicTasksExecutor)taskExecutor, httpServer);
            this.replyReceiver = new TCPReplyReceiver(this.wirelessTransmitter);
            this.replyReceiver.start();
            this.shutdownables.add(this.replyReceiver);
            this.shutdownables.add((Shutdownable)this.wirelessTransmitter);
            this.shutdownables.add((Shutdownable)this.accessPointModule);
            this.shutdownables.add(new HttpHandlerDeregistrator((BasicHttpServer)httpServer, configuration.getServerConfiguration()));
            this.updateFirmaware(Version.UNDEFINED);
            EnvironmentProperties environmentProperties = new EnvironmentProperties(false);
            ServiceAddress localServiceAddress = configuration.getServerConfiguration().createServiceAddress(false, environmentProperties.getIPAddress());
            ServiceAddress remoteServiceAddress = null;
            if (!tcpAPSettings.useThinMode() || AccessPointTypeMapping.getType((int)configuration.getAccessPointId()) != AccessPointType.SIMULATED) {
                remoteServiceAddress = new ServiceAddress(false, configuration.getRemoteAddress(), configuration.getRemotePort());
            }
            this.thinAccessPointService = new ThinAccessPointService(localServiceAddress, remoteServiceAddress, this.accessPoint, this.accessPointDataListener, requestQueue, AccessPointProtocol.THIN_TCP);
            this.running = true;
        }
        catch (InitializationException ie) {
            throw ie;
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public TCPReplyReceiver getReplyReceiver() {
        return this.replyReceiver;
    }

    public void setChannelStatusProvider(ChannelStatusProvider channelStatusProvider) {
        this.accessPointDataListener.setChannelStatusProvider(channelStatusProvider);
    }

    public void setDaemonInfoProvider(DaemonInfoProvider daemonInfoProvider) {
        this.accessPointDataListener.setDaemonInfoProvider(daemonInfoProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        logger.info("Shuting down TCP AccessPoint.");
        Set<Shutdownable> set = this.shutdownables;
        synchronized (set) {
            for (Shutdownable shutdownable : this.shutdownables) {
                shutdownable.shutdown();
            }
        }
        this.running = false;
    }

    @Override
    public ThinAccessPointConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void updateChannel(WirelessChannel channel) {
        this.configurationStorage.setWirelessChannel(channel);
    }

    @Override
    public void setConnectionStatus(ConnectionStatus status) {
        this.accessPointDataListener.updateConnectionStatus(status);
    }

    public void setProtocolUsingTLS(boolean protocolUsingTLS) {
        this.accessPointDataListener.updateProtocolUsingTLS(protocolUsingTLS);
    }

    public AccessPointService getAccessPointService() {
        return this.thinAccessPointService;
    }

    public TCPWirelessTransmitter getWirelessTransmitter() {
        return this.wirelessTransmitter;
    }

    public void updateFirmaware(Version firmwareVersion) {
        this.accessPointModule.getAccessPoint().setFirmwareVersion(firmwareVersion);
    }

    public void updateMaxAllowedWindowSize(int maxAllowedWindowSize) {
        if (maxAllowedWindowSize > 0 && maxAllowedWindowSize <= 14) {
            logger.info("Setting window size to: %d", new Object[]{maxAllowedWindowSize});
            this.configurationStorage.setWindowSize(maxAllowedWindowSize);
        } else {
            logger.warn("Got invalid max allowed window size, ignoring it!");
        }
    }

    public APCProviderHolder getProviderHolder() {
        return this.providerHolder;
    }

    public void setProviderHolder(APCProviderHolder holderStore) {
        this.providerHolder = holderStore;
        this.setChannelStatusProvider(holderStore);
        this.setDaemonInfoProvider(holderStore);
    }
}

