/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level3.http;

import at.mrdevelopment.esl.custom.level3.Level3Interface;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.xml.ArticleXMLSerializer;
import at.mrdevelopment.esl.xml.TransactionXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;
import org.w3c.dom.Document;

@Route(route="/service/article")
public class StoreArticleWebserviceRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(StoreArticleWebserviceRequestHandler.class);
    private final Level3Interface level3;
    private final ArticleXMLSerializer articleSerializer;
    private final TransactionXMLSerializer transactionSerializer;

    public StoreArticleWebserviceRequestHandler(Level3Interface level3) throws InitializationException {
        this.level3 = level3;
        this.articleSerializer = new ArticleXMLSerializer();
        this.transactionSerializer = new TransactionXMLSerializer();
    }

    @Route(method=HttpRequestMethod.POST, route="store.xml")
    public void storeArticle(WebserviceRequest request, WebserviceResponse response) throws Exception {
        List articles = this.articleSerializer.parseXML(request.getBody().getContent());
        if (articles.size() == 1) {
            Article article = (Article)articles.get(0);
            TaskTransaction transaction = this.level3.storeArticle(article, 0L);
            Document document = this.transactionSerializer.toXML(transaction);
            response.respondDocument(document, request.isGzipEncodingAccepted());
        } else {
            response.respondBadRequest();
        }
    }

    @Route(method=HttpRequestMethod.POST, route="delete.xml")
    public void deleteArticle(WebserviceRequest request, WebserviceResponse response) throws Exception {
        response.respondBadRequest();
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

