/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level3.http;

import at.mrdevelopment.esl.custom.level3.Level3Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.ArticleRecord;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.toolkit.file.CsvBuilder;
import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentProducer;

@Route(route="/service/export")
public class ExportLevel3WebserviceRequestHandler
implements WebserviceRequestHandler {
    private final Level3Interface level3;

    public ExportLevel3WebserviceRequestHandler(Level3Interface level3) {
        this.level3 = level3;
    }

    @Route(method=HttpRequestMethod.GET, route="articles.csv")
    public void exportArticles(WebserviceRequest request, WebserviceResponse response) throws DatasetException {
        DatasetQuery query = this.level3.getQuery("articlerecord/index");
        QueryResult queryResult = this.level3.executeQuery(query, QueryRestriction.newUnpagedQuery());
        CsvBuilder csvBuilder = new CsvBuilder();
        for (ArticleRecord articleRecord : queryResult.getRecords()) {
            Article article = articleRecord.toArticle();
            ArrayList<String> csvRecord = new ArrayList<String>(2 + article.getFieldsCount());
            csvRecord.add(article.getArticleNumber().toString());
            csvRecord.add(StringUtils.join((Collection)article.getGtins(), (String)","));
            csvRecord.addAll(article.getFieldsAsSortedStringList());
            csvBuilder.addRecord(csvRecord);
        }
        response.respondContentProducer((ContentProducer)csvBuilder, HttpContentType.PLAIN_UTF8, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

