/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level2.http;

import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.custom.level2.http.ModifyMatchingsWebserviceRequestHandler;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.xml.ArticleXMLSerializer;
import at.mrdevelopment.esl.xml.TransactionXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;
import org.w3c.dom.Document;

@Route(route="/service/article")
public class UpdateArticleWebserviceRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(ModifyMatchingsWebserviceRequestHandler.class);
    private final Level2Interface level2;
    private final ArticleXMLSerializer articleSerializer;
    private final TransactionXMLSerializer transactionSerializer;

    public UpdateArticleWebserviceRequestHandler(Level2Interface level2) throws InitializationException {
        this.level2 = level2;
        this.articleSerializer = new ArticleXMLSerializer();
        this.transactionSerializer = new TransactionXMLSerializer();
    }

    @Route(method=HttpRequestMethod.POST, route="update.xml")
    public void handleModify(WebserviceRequest request, WebserviceResponse response) throws Exception {
        logger.info("Received modify request");
        List articles = this.articleSerializer.parseXML(request.getBody().getContent());
        if (articles.size() == 1) {
            Article article = (Article)articles.get(0);
            ArticleNumber articleNumber = article.getArticleNumber();
            TaskTransaction transaction = this.level2.articleUpdated(articleNumber, 0L);
            Document document = this.transactionSerializer.toXML(transaction);
            response.respondDocument(document, request.isGzipEncodingAccepted());
        } else {
            response.respondBadRequest();
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

