/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level2.http;

import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Gtin;
import at.mrdevelopment.esl.xml.ArticleXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.w3c.dom.Document;

@Route(route="/service/article")
public class QueryArticleWebserviceRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(QueryArticleWebserviceRequestHandler.class);
    private final Level2Interface level2;
    private final ArticleXMLSerializer articleSerializer;

    public QueryArticleWebserviceRequestHandler(Level2Interface level2) throws InitializationException {
        this.level2 = level2;
        this.articleSerializer = new ArticleXMLSerializer();
    }

    @Route(method=HttpRequestMethod.GET, route=":key.xml", pattern="[0-9A-Z_-]+")
    public void getArticle(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ArticleNumber articleNumber = ArticleNumber.fromString((String)request.getUrlBaseName());
        Article article = this.level2.queryArticle(articleNumber);
        if (article != null) {
            Document document = this.articleSerializer.toXML(article);
            response.respondDocument(document, request.isGzipEncodingAccepted());
        } else {
            response.respondFileNotFound();
        }
    }

    @Route(method=HttpRequestMethod.GET, route="gtin/:key.xml", pattern="[0-9]+")
    public void getArticleByGtin(WebserviceRequest request, WebserviceResponse response) throws Exception {
        Gtin gtin = Gtin.fromString((String)request.getUrlBaseName());
        Article article = this.level2.queryArticle(gtin);
        Document document = this.articleSerializer.toXML(article);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

