/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level2.http;

import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.xml.MatchingXMLSerializer;
import at.mrdevelopment.esl.xml.TransactionXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;
import org.w3c.dom.Document;

@Route(route="/service/matching")
public class ModifyMatchingsWebserviceRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(ModifyMatchingsWebserviceRequestHandler.class);
    private final Level2Interface level2;
    private final MatchingXMLSerializer matchingSerializer;
    private final TransactionXMLSerializer transactionSerializer;

    public ModifyMatchingsWebserviceRequestHandler(Level2Interface level2) throws InitializationException {
        this.level2 = level2;
        this.matchingSerializer = new MatchingXMLSerializer();
        this.transactionSerializer = new TransactionXMLSerializer();
    }

    @Route(method=HttpRequestMethod.POST, route="modify.xml")
    public void handleModify(WebserviceRequest request, WebserviceResponse response) throws Exception {
        logger.info("Received modify request");
        Collection matchings = this.matchingSerializer.parseXML(request.getBody().getContent());
        logger.info("Received %d matchings", new Object[]{matchings.size()});
        TaskTransaction transaction = this.level2.modifyMatchings(matchings, 0L);
        Document document = this.transactionSerializer.toXML(transaction);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

