/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level2.http;

import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.MatchingRecord;
import at.mrdevelopment.toolkit.file.CsvBuilder;
import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import org.apache.http.entity.ContentProducer;

@Route(route="/service/export")
public class ExportLevel2WebserviceRequestHandler
implements WebserviceRequestHandler {
    private final Level2Interface level2;

    public ExportLevel2WebserviceRequestHandler(Level2Interface level2) {
        this.level2 = level2;
    }

    @Route(method=HttpRequestMethod.GET, route="matchings.csv")
    public void exportMatchings(WebserviceRequest request, WebserviceResponse response) throws DatasetException {
        DatasetQuery query = this.level2.getQuery("matchingrecord/index");
        QueryResult queryResult = this.level2.executeQuery(query, QueryRestriction.newUnpagedQuery());
        CsvBuilder csvBuilder = new CsvBuilder();
        for (MatchingRecord matching : queryResult.getRecords()) {
            csvBuilder.addRecord(new String[]{matching.getLabelIdString(), matching.getArticleNumber().toString(), matching.getTemplate()});
        }
        response.respondContentProducer((ContentProducer)csvBuilder, HttpContentType.PLAIN_UTF8, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

