/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level1.http;

import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelPageContent;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.UUID;

@Route(route="/service")
public class UpdateImageWebserviceRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(UpdateImageWebserviceRequestHandler.class);
    private final Level1Interface level1;

    public UpdateImageWebserviceRequestHandler(Level1Interface level1) {
        this.level1 = level1;
    }

    @Route(method=HttpRequestMethod.GET, route="updatestatus/image/:key.png", pattern="[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}")
    public void getImage(WebserviceRequest request, WebserviceResponse response) throws Exception {
        this.respondImage(request, response, true);
    }

    @Route(method=HttpRequestMethod.GET, route="updatestatus/rawimage/:key.png", pattern="[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}")
    public void getRawImage(WebserviceRequest request, WebserviceResponse response) throws Exception {
        this.respondImage(request, response, false);
    }

    @Route(method=HttpRequestMethod.GET, route="labelpagecontent/image/:key.png", pattern="[0-9]+")
    public void getLabelPageContentImage(WebserviceRequest request, WebserviceResponse response) throws Exception {
        long id = Long.valueOf(request.getUrlBaseName());
        DatasetQuery query = this.level1.getQuery("labelpagecontent/id");
        List records = this.level1.executeQuery(query, QueryRestriction.newUnpagedSearchQuery(Long.class, (Object)id)).getRecords();
        if (records != null && records.size() > 0) {
            UpdateImage updateImage = ((LabelPageContent)records.get(0)).getUpdateImage();
            if (updateImage != null && updateImage.getBufferedImage() != null) {
                response.respondImage(updateImage.getBufferedImage());
            } else {
                response.respondFileNotFound(String.format("Label Page Content image %s not found", id));
            }
        }
    }

    private void respondImage(WebserviceRequest request, WebserviceResponse response, boolean convert) throws SerializeException, DatasetException {
        UUID taskId = UUID.fromString(request.getUrlBaseName());
        BufferedImage image = this.level1.getImageForTask(taskId, convert);
        if (image != null) {
            response.respondImage(image);
        } else {
            response.respondFileNotFound(String.format("Task %s not found", taskId));
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

