/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level1.http;

import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.FileEntity;

@Route(route="/service/logging")
public class LoggingWebserviceRequestHandler
implements WebserviceRequestHandler {
    private static final Pattern BACKEND_PATTERN = Pattern.compile("backend\\.log(.[1-9])*");
    private static final String BACKEND_PATH = "/opt/esl/backend/";

    @Route(method=HttpRequestMethod.GET, route=":key", pattern=".+\\.log(.[1-9])*")
    public void getLogFile(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String filename = FilenameUtils.getName((String)request.getRequestUri().getPath());
        if (BACKEND_PATTERN.matcher(filename).matches()) {
            this.respondLogFile(response, new File(BACKEND_PATH + filename));
        } else {
            this.respondLogFile(response, new File(filename));
        }
    }

    private void respondLogFile(WebserviceResponse response, File logFile) throws SerializeException {
        if (logFile.exists()) {
            FileEntity body = new FileEntity(logFile);
            body.setContentType(HttpContentType.PLAIN.getValue());
            response.respondEntity((HttpEntity)body, 200);
        } else {
            response.respondFileNotFound();
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

