/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level1.http;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.xml.AbortRequestXMLSerializer;
import at.mrdevelopment.esl.xml.LabelRegistrationXMLSerializer;
import at.mrdevelopment.esl.xml.LabelXMLSerializer;
import at.mrdevelopment.esl.xml.TagsUpdateXMLSerializer;
import at.mrdevelopment.esl.xml.TaskXMLSerializer;
import at.mrdevelopment.esl.xml.TransactionXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import org.w3c.dom.Document;

@Route(route="/service")
public class Level1WebserviceRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(Level1WebserviceRequestHandler.class);
    private final Level1Interface level1Interface;
    private final TaskXMLSerializer taskSerializer;
    private final AbortRequestXMLSerializer abortRequestSerializer;
    private final LabelRegistrationXMLSerializer labelRegistrationSerializer;
    private final LabelXMLSerializer labelSerializer;
    private final TagsUpdateXMLSerializer tagsUpdateSerializer;
    private final TransactionXMLSerializer transactionSerializer;

    public Level1WebserviceRequestHandler(Level1Interface level1Interface) throws InitializationException {
        this.level1Interface = level1Interface;
        this.taskSerializer = new TaskXMLSerializer();
        this.abortRequestSerializer = new AbortRequestXMLSerializer();
        this.labelRegistrationSerializer = new LabelRegistrationXMLSerializer();
        this.labelSerializer = new LabelXMLSerializer();
        this.tagsUpdateSerializer = new TagsUpdateXMLSerializer();
        this.transactionSerializer = new TransactionXMLSerializer();
    }

    @Route(method=HttpRequestMethod.POST, route="tasks/add.xml")
    public void postTasks(WebserviceRequest request, WebserviceResponse response) throws Exception {
        InputStream inputStream = request.getBody().getContent();
        File templateDirectory = new File(Config.getTemplatePath());
        TaskOrder taskOrder = this.taskSerializer.parseXMLFromStream(inputStream, templateDirectory);
        logger.info("Processing task order '%s'", new Object[]{taskOrder.getTitle()});
        TaskTransaction transaction = this.level1Interface.addTasks(taskOrder);
        Document document = this.transactionSerializer.toXML(transaction);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.POST, route="abort.xml")
    public void abort(WebserviceRequest request, WebserviceResponse response) throws Exception {
        InputStream inputStream = request.getBody().getContent();
        Collection abortRequests = this.abortRequestSerializer.parseXML(inputStream);
        this.level1Interface.abort(abortRequests);
        response.respondMessage(String.format("Scheduled %d abort requests", abortRequests.size()));
    }

    @Route(method=HttpRequestMethod.POST, route="labels/register.xml")
    public void registerLabels(WebserviceRequest request, WebserviceResponse response) throws Exception {
        InputStream inputStream = request.getBody().getContent();
        Collection registrations = this.labelRegistrationSerializer.parseXML(inputStream);
        TaskTransaction transaction = this.level1Interface.registerLabels(registrations, 0L);
        Document document = this.transactionSerializer.toXML(transaction);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.POST, route="labels/unregister.xml")
    public void unregisterLabels(WebserviceRequest request, WebserviceResponse response) throws Exception {
        InputStream inputStream = request.getBody().getContent();
        Collection labels = this.labelSerializer.parseXML(inputStream);
        TaskTransaction transaction = this.level1Interface.unregisterLabels(labels, 0L);
        Document document = this.transactionSerializer.toXML(transaction);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.POST, route="labels/tags/update.xml")
    public void updateLabelTags(WebserviceRequest request, WebserviceResponse response) throws Exception {
        InputStream inputStream = request.getBody().getContent();
        Collection tagsUpdates = this.tagsUpdateSerializer.parseXML(inputStream);
        logger.info(String.format("Updated tags on %d labels", tagsUpdates.size()));
        this.level1Interface.updateLabelTags(tagsUpdates);
        response.respondMessage(String.format("Updated tags on %d labels", tagsUpdates.size()));
    }

    @Route(method=HttpRequestMethod.GET, route="test.xml")
    public void test(WebserviceRequest request, WebserviceResponse response) throws Exception {
        response.respondMessage("Ok");
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

