/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level1.http;

import at.mrdevelopment.esl.csvimport.LabelRegistrationCsvImport;
import at.mrdevelopment.esl.csvimport.LicenceCsvImport;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.type.Licence;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import java.util.Collection;
import java.util.List;
import org.apache.http.HttpEntity;

@Route(route="/service/import")
public class ImportLevel1WebserviceRequestHandler
implements WebserviceRequestHandler {
    private final Level1Interface level1;

    public ImportLevel1WebserviceRequestHandler(Level1Interface level1) {
        this.level1 = level1;
    }

    @Route(method=HttpRequestMethod.POST, route="labels")
    public void importRegisteredLabels(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        LabelRegistrationCsvImport labelImport = new LabelRegistrationCsvImport();
        List labelRegistrations = labelImport.importFromStream(body.getContent());
        TaskTransaction transaction = this.level1.registerLabels((Collection)labelRegistrations, 0L);
        String message = String.format("Imported %d labels in transaction %d", labelRegistrations.size(), transaction.getId());
        response.respondPlainText(message);
    }

    @Route(method=HttpRequestMethod.POST, route="accesspoints")
    public void importAccessPointConfiguraion(WebserviceRequest request, WebserviceResponse response) throws Exception {
        response.respondPlainText("Not implemented yet");
    }

    @Route(method=HttpRequestMethod.POST, route="configuration")
    public void importConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        response.respondPlainText("Not implemented yet");
    }

    @Route(method=HttpRequestMethod.POST, route="licences")
    public void importLicences(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        LicenceCsvImport licenceImport = new LicenceCsvImport();
        List licences = licenceImport.importFromStream(body.getContent());
        for (Licence licence : licences) {
            this.level1.addLicense(licence);
        }
        String message = String.format("Imported %d licenses", licences.size());
        response.respondPlainText(message);
    }

    @Route(method=HttpRequestMethod.POST, route="tags")
    public void importTags(WebserviceRequest request, WebserviceResponse response) throws Exception {
        response.respondPlainText("Not implemented yet");
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

