/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level1.http;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelTagsLookup;
import at.mrdevelopment.esl.rendering.ConfigBasedImageRenderingEngineConfiguration;
import at.mrdevelopment.esl.server.ConfigEnvironmentSource;
import at.mrdevelopment.esl.tasks.ConfigBasedRenderedImageConverter;
import at.mrdevelopment.esl.tasks.DefaultRecordSourceLogger;
import at.mrdevelopment.esl.tasks.EnvironmentSource;
import at.mrdevelopment.esl.tasks.ImageRenderingTask;
import at.mrdevelopment.esl.tasks.RecordSourceLogger;
import at.mrdevelopment.esl.tasks.RenderedImageConverter;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.template.ImageRenderingEngineConfiguration;
import at.mrdevelopment.esl.template.ImageRenderingEngineWrapper;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.xml.TaskXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.imagotag.rendering.ImageRenderingEngine;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;

@Route(route="/service/rendering/preview")
public class ImageRenderingWebserviceRequestHandler
implements WebserviceRequestHandler {
    private final TaskXMLSerializer taskSerializer = new TaskXMLSerializer();
    private final UpdateImageFactory updateImageFactory;

    public ImageRenderingWebserviceRequestHandler(ImageRenderingEngine renderingEngine, LabelTagsLookup labelTagsLookup) throws InitializationException {
        this.updateImageFactory = new UpdateImageFactory(new ImageRenderingEngineWrapper(renderingEngine, (ImageRenderingEngineConfiguration)new ConfigBasedImageRenderingEngineConfiguration()), (RenderedImageConverter)new ConfigBasedRenderedImageConverter(), (RecordSourceLogger)new DefaultRecordSourceLogger(), (EnvironmentSource)new ConfigEnvironmentSource(), labelTagsLookup);
    }

    @Route(method=HttpRequestMethod.POST, route="source.xml")
    public void buildDocumentSourceForTemplateTask(WebserviceRequest request, WebserviceResponse response) throws Exception {
        TemplateTask templateTask = this.parseTemplateTaskFromRequest(request);
        Document document = (Document)this.updateImageFactory.buildRecordSource(templateTask).getNode();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.POST, route="image.xml")
    public void transformTemplateTask(WebserviceRequest request, WebserviceResponse response) throws Exception {
        TemplateTask templateTask = this.parseTemplateTaskFromRequest(request);
        Document document = (Document)this.updateImageFactory.buildImageRenderingSource(templateTask).getNode();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.POST, route="image.png")
    public void renderTemplateTask(WebserviceRequest request, WebserviceResponse response) throws Exception {
        TemplateTask templateTask = this.parseTemplateTaskFromRequest(request);
        BufferedImage image = this.updateImageFactory.createImageFromTask((ImageRenderingTask)templateTask);
        response.respondImage(image);
    }

    private TemplateTask parseTemplateTaskFromRequest(WebserviceRequest request) throws IllegalStateException, IllegalArgumentException, IOException, SerializeException {
        File templateDirectory;
        InputStream inputStream = request.getBody().getContent();
        TaskOrder taskOrder = this.taskSerializer.parseXMLFromStream(inputStream, templateDirectory = new File(Config.getTemplatePath()));
        if (taskOrder.getSize() != 1) {
            throw new IllegalArgumentException("Request is only valid for a single template task");
        }
        Task task = (Task)taskOrder.getTasks().get(0);
        if (!(task instanceof TemplateTask)) {
            throw new IllegalArgumentException("Request is only valid for a single template task");
        }
        return (TemplateTask)task;
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

