/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level1.http;

import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.AccessPointConfiguration;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.persistence.record.LicenceRecord;
import at.mrdevelopment.esl.type.Tag;
import at.mrdevelopment.toolkit.file.CsvBuilder;
import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentProducer;

@Route(route="/service/export")
public class ExportLevel1WebserviceRequestHandler
implements WebserviceRequestHandler {
    private final Level1Interface level1;

    public ExportLevel1WebserviceRequestHandler(Level1Interface level1) {
        this.level1 = level1;
    }

    @Route(method=HttpRequestMethod.GET, route="labels.csv")
    public void exportRegisteredLabels(WebserviceRequest request, WebserviceResponse response) throws DatasetException, SerializeException {
        List labelRegistrations = this.level1.getRegisteredLabels();
        CsvBuilder csvBuilder = new CsvBuilder();
        for (LabelRegistration labelRegistration : labelRegistrations) {
            String labelId = labelRegistration.getLabelId().getLabelIdString();
            String tags = labelRegistration.getTagsString();
            csvBuilder.addRecord(new String[]{labelId, tags});
        }
        response.respondContentProducer((ContentProducer)csvBuilder, HttpContentType.PLAIN_UTF8, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="accesspoints.csv")
    public void exportAccessPointConfiguration(WebserviceRequest request, WebserviceResponse response) throws DatasetException {
        DatasetQuery query = this.level1.getQuery("accesspointconfiguration/index");
        QueryResult queryResult = this.level1.executeQuery(query, QueryRestriction.newUnpagedQuery());
        CsvBuilder csvBuilder = new CsvBuilder();
        for (AccessPointConfiguration configuration : queryResult.getRecords()) {
            String[] stringArray = new String[10];
            stringArray[0] = Integer.toString(configuration.getAccessPointId());
            stringArray[1] = configuration.getAddress();
            stringArray[2] = configuration.getPort() != null ? (configuration.getPort() >= 0 ? Integer.toString(configuration.getPort()) : "") : "";
            stringArray[3] = configuration.getSsl() != null ? Boolean.toString(configuration.getSsl()) : "";
            stringArray[4] = configuration.getHostName();
            stringArray[5] = configuration.getSubnetMask();
            stringArray[6] = configuration.getGateway();
            stringArray[7] = configuration.getDns();
            stringArray[8] = configuration.getChannel() != null ? Integer.toString(configuration.getChannel().getChannelId()) : "";
            stringArray[9] = configuration.getType().name();
            csvBuilder.addRecord(stringArray);
        }
        response.respondContentProducer((ContentProducer)csvBuilder, HttpContentType.PLAIN_UTF8, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="configuration.csv")
    public void exportConfiguration(WebserviceRequest request, WebserviceResponse response) throws DatasetException {
        DatasetQuery query = this.level1.getQuery("configuration/index");
        QueryResult queryResult = this.level1.executeQuery(query, QueryRestriction.newUnpagedQuery());
        CsvBuilder csvBuilder = new CsvBuilder();
        for (Configuration entry : Configuration.filterModified((Iterable)queryResult.getRecords())) {
            csvBuilder.addRecord(new String[]{entry.getKey(), entry.getValue()});
        }
        response.respondContentProducer((ContentProducer)csvBuilder, HttpContentType.PLAIN_UTF8, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="licences.csv")
    public void exportLicences(WebserviceRequest request, WebserviceResponse response) throws DatasetException {
        DatasetQuery query = this.level1.getQuery("licencerecord/index");
        QueryResult queryResult = this.level1.executeQuery(query, QueryRestriction.newUnpagedQuery());
        CsvBuilder csvBuilder = new CsvBuilder();
        for (LicenceRecord licence : queryResult.getRecords()) {
            csvBuilder.addRecord(new String[]{licence.getComment(), StringUtils.deleteWhitespace((String)licence.getLicenceKey())});
        }
        response.respondContentProducer((ContentProducer)csvBuilder, HttpContentType.PLAIN_UTF8, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="tags.csv")
    public void exportTags(WebserviceRequest request, WebserviceResponse response) throws DatasetException {
        DatasetQuery query = this.level1.getQuery("tags");
        QueryResult queryResult = this.level1.executeQuery(query, QueryRestriction.newUnpagedQuery());
        CsvBuilder csvBuilder = new CsvBuilder();
        for (Tag tag : queryResult.getRecords()) {
            csvBuilder.addRecord(new String[]{tag.getName()});
        }
        response.respondContentProducer((ContentProducer)csvBuilder, HttpContentType.PLAIN_UTF8, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

