/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.level1.http;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.network.NetworkStatus;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.xml.LabelXMLSerializer;
import at.mrdevelopment.esl.xml.NetworkStatusXMLSerializer;
import at.mrdevelopment.esl.xml.ServiceStatusXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.Routes;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;

@Route(route="/service")
public class ESLWebserviceRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(ESLWebserviceRequestHandler.class);
    private final Level1Interface level1;
    private final ServiceStatusXMLSerializer serviceStatusSerializer;
    private final NetworkStatusXMLSerializer networkStatusSerializer;
    private final LabelXMLSerializer labelSerializer;

    public ESLWebserviceRequestHandler(Level1Interface level1) throws InitializationException {
        this.level1 = level1;
        this.serviceStatusSerializer = new ServiceStatusXMLSerializer();
        this.networkStatusSerializer = new NetworkStatusXMLSerializer();
        this.labelSerializer = new LabelXMLSerializer();
    }

    @Routes(value={@Route(method=HttpRequestMethod.GET, route="labels/registered.xml"), @Route(method=HttpRequestMethod.GET, route="serials.xml")})
    public void getRegisteredLabels(WebserviceRequest request, WebserviceResponse response) throws DatasetException, SerializeException {
        List labelRegistrations = this.level1.getRegisteredLabels();
        Collection labels = Collections2.transform((Collection)labelRegistrations, (Function)new Function<LabelRegistration, LabelId>(){

            public LabelId apply(LabelRegistration labelRegistration) {
                return labelRegistration.getLabelId();
            }
        });
        Document document = this.labelSerializer.toXML(labels);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="status.xml")
    public void getServiceStatus(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        ServiceStatus serviceStatus = this.level1.getServiceStatus(request.getUser());
        Document document = this.serviceStatusSerializer.toXML(serviceStatus);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="network.xml")
    public void getNetworkStatus(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        NetworkStatus networkStatus = this.level1.getNetworkStatus();
        Document document = this.networkStatusSerializer.toXML(networkStatus);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="problems.xml")
    public void getProblems(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        ServiceStatus serviceStatus = this.level1.getServiceStatus(request.getUser());
        Document document = this.serviceStatusSerializer.toXML(serviceStatus.getProblems());
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

