/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml.sax;

import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.ChannelTableEntry;
import at.mrdevelopment.esl.wireless.RoamingAssignment;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.xml.sax.AbstractSAXContentHandler;
import java.util.ArrayList;
import java.util.Collection;
import joptsimple.internal.Strings;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RoamingTableContentHandler
extends AbstractSAXContentHandler<RoamingTable> {
    private Collection<ChannelTableEntry> channelTable;
    private Collection<RoamingAssignment> roamingAssignments;
    private int protocolId;
    private int validTimeInMinutes;
    private int pingIntervalInMinutes;
    private boolean acceptAllLabels;
    private boolean encryptionRequired;
    private boolean allowBlacklistedLabels;
    private Key key;
    private SyncProfile syncProfile;

    public void setDocumentLocator(Locator locator) {
    }

    public void endDocument() throws SAXException {
        this.result = new RoamingTable(this.protocolId, this.validTimeInMinutes, this.pingIntervalInMinutes, this.channelTable, this.roamingAssignments, this.acceptAllLabels, this.encryptionRequired, this.allowBlacklistedLabels, this.key, this.syncProfile);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals("roaming-table")) {
            this.protocolId = this.parseInteger(atts.getValue("protocol-id"), 0);
            this.pingIntervalInMinutes = Integer.valueOf(atts.getValue("ping-interval"));
            this.validTimeInMinutes = Integer.valueOf(atts.getValue("valid-for-minutes"));
            this.acceptAllLabels = this.parseBoolean(atts.getValue("accept-all-labels"), false);
            this.encryptionRequired = this.parseBoolean(atts.getValue("encryption-required"), false);
            this.allowBlacklistedLabels = this.parseBoolean(atts.getValue("allow-blacklisted-labels"), true);
            this.key = this.parseKey(atts.getValue("network-key"));
            this.syncProfile = this.parseSyncProfile(atts.getValue("sync-profile"));
        } else if (localName.equals("channel-table")) {
            this.channelTable = new ArrayList<ChannelTableEntry>();
        } else if (localName.equals("channel-entry")) {
            int accessPointId = this.parseAccessPointId(atts.getValue("access-point"));
            WirelessChannel channel = WirelessChannel.fromString(atts.getValue("channel"));
            this.channelTable.add(new ChannelTableEntry(accessPointId, channel));
        } else if (localName.equals("roaming-assignments")) {
            this.roamingAssignments = new ArrayList<RoamingAssignment>();
        } else if (localName.equals("roaming")) {
            Address address = Address.fromString(atts.getValue("address"));
            LabelType labelType = this.parseLabelType(atts.getValue("type"));
            int accessPointId = this.parseAccessPointId(atts.getValue("access-point"));
            Pin pin = this.parsePin(atts.getValue("pin"));
            this.roamingAssignments.add(new RoamingAssignment(address, pin, labelType, accessPointId));
        }
    }

    private int parseInteger(String value, int defaultValue) {
        return Strings.isNullOrEmpty((String)value) ? defaultValue : Integer.parseInt(value);
    }

    private boolean parseBoolean(String value, boolean defaultValue) {
        return Strings.isNullOrEmpty((String)value) ? defaultValue : Boolean.parseBoolean(value);
    }

    private LabelType parseLabelType(String typeString) {
        return Strings.isNullOrEmpty((String)typeString) ? null : LabelType.fromString(typeString);
    }

    private Key parseKey(String keyBase64) {
        return Strings.isNullOrEmpty((String)keyBase64) ? Key.emptyKey() : Key.fromBase64(keyBase64);
    }

    private Pin parsePin(String pinBase64) {
        return Strings.isNullOrEmpty((String)pinBase64) ? null : Pin.fromBase64(pinBase64);
    }

    private int parseAccessPointId(String accessPointIdString) {
        return Strings.isNullOrEmpty((String)accessPointIdString) ? 0 : Integer.valueOf(accessPointIdString);
    }

    private SyncProfile parseSyncProfile(String value) {
        return SyncProfile.fromString(value);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void onStartDocument() {
    }
}

