/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WakeupStatisticXMLSerializer
implements XMLSerializer<WakeupStatistic> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Element wakeupStatisticToXML(Document document, WakeupStatistic wakeupStatistic) {
        Element element = document.createElement("wakeup-statistic");
        element.setAttribute("address", wakeupStatistic.getLabelAddress().toString());
        element.setAttribute("access-point", Integer.toString(wakeupStatistic.getAccessPointId()));
        element.setAttribute("count", Long.toString(wakeupStatistic.getWakeupCount()));
        if (wakeupStatistic.getWakeupCount() > 0L) {
            element.setAttribute("time", this.xmlToolkit.formatTime(wakeupStatistic.getLastPingReplyTime()));
            element.setAttribute("firmware", wakeupStatistic.getFirmwareVersion().getVersionString());
            element.setAttribute("sync-quality", Integer.toString(wakeupStatistic.getSyncQuality().getSyncQualityValue()));
            element.setAttribute("power-status", wakeupStatistic.getPowerStatus().toString());
            element.setAttribute("key-unset", Boolean.toString(wakeupStatistic.isKeyUnset()));
            element.setAttribute("keys-not-programmed", Boolean.toString(wakeupStatistic.areKeysNotProgrammed()));
            element.setAttribute("page", wakeupStatistic.getCurrentPage().getPageString());
            element.setAttribute("error-code", Integer.toString(wakeupStatistic.getLabelErrors().getErrorCode()));
            element.setAttribute("rssi", Integer.toString(wakeupStatistic.getLastRssi()));
            element.setAttribute("lqi", Integer.toString(wakeupStatistic.getLastLqi()));
            element.setAttribute("sync", wakeupStatistic.getSyncQuality().getSyncQualityLevel().toString());
        }
        return element;
    }

    public void updateTime(Element element, DateTime lastWakeupTime, DateTime now) {
        if (lastWakeupTime != null) {
            element.setAttribute("time-relative", Long.toString(this.xmlToolkit.getRelativeTime(now, lastWakeupTime)));
        }
    }

    public void updateConnectionStatus(Element element, ConnectionStatus connectionStatus) {
        element.setAttribute("connection", connectionStatus.toString());
    }

    public void removeNewFields(Element element) {
        element.removeAttribute("key-unset");
        element.removeAttribute("keys-not-programmed");
    }

    public Document newDocument() {
        return this.xmlToolkit.newDocument();
    }

    public Collection<WakeupStatistic> parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        NodeList nodes = root.getElementsByTagName("wakeup-statistic");
        ArrayList<WakeupStatistic> wakeupStatistics = new ArrayList<WakeupStatistic>(nodes.getLength());
        DateTime now = DateTime.now();
        for (int index = 0; index < nodes.getLength(); ++index) {
            try {
                WakeupStatistic wakeupStatistic = this.parseWakeupStatisticFromXML((Element)nodes.item(index), now);
                wakeupStatistics.add(wakeupStatistic);
                continue;
            }
            catch (RuntimeException exc) {
                throw new SerializeException((Throwable)exc);
            }
        }
        return wakeupStatistics;
    }

    private WakeupStatistic parseWakeupStatisticFromXML(Element element, DateTime now) throws NumberFormatException {
        Address labelAddress = Address.fromString(element.getAttribute("address"));
        int accessPointId = Integer.parseInt(element.getAttribute("access-point"));
        long wakeupCount = Long.parseLong(element.getAttribute("count"));
        if (wakeupCount > 0L) {
            boolean keysNotProgrammed;
            boolean keyUnset;
            DateTime pingReplyTime = this.xmlToolkit.getLocalTimeFromRelativeTime(now, Long.parseLong(element.getAttribute("time-relative")));
            Version firmwareVersion = Version.fromString((String)element.getAttribute("firmware"));
            SyncQuality syncQuality = SyncQuality.valueOf(element.getAttribute("sync-quality"));
            PowerStatus powerStatus = PowerStatus.valueOf(element.getAttribute("power-status"));
            if (element.hasAttribute("shelf-mounted")) {
                keyUnset = Boolean.valueOf(element.getAttribute("shelf-mounted"));
                keysNotProgrammed = false;
            } else {
                keyUnset = element.hasAttribute("key-unset") ? Boolean.valueOf(element.getAttribute("key-unset")) : true;
                keysNotProgrammed = Boolean.valueOf(element.getAttribute("keys-not-programmed"));
            }
            Page currentPage = Page.fromString(element.getAttribute("page"));
            LabelErrors errorCode = LabelErrors.valueOf(element.getAttribute("error-code"));
            int rssi = Integer.parseInt(element.getAttribute("rssi"));
            int linkQuality = Integer.parseInt(element.getAttribute("lqi"));
            return new WakeupStatistic(labelAddress, accessPointId, wakeupCount, pingReplyTime, firmwareVersion, syncQuality, powerStatus, keyUnset, keysNotProgrammed, currentPage, errorCode, rssi, linkQuality);
        }
        return new WakeupStatistic(labelAddress, accessPointId);
    }
}

