/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.statistic.UtilizationSource;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UtilizationSourceXMLSerializer
implements XMLSerializer<UtilizationSource> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Collection<UtilizationSource> utilizationSources) {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("utilizations");
        for (UtilizationSource utilizationSource : utilizationSources) {
            Element sourceElement = document.createElement("utilization");
            sourceElement.setAttribute("name", utilizationSource.getName());
            sourceElement.setAttribute("current", this.asPercentageString(utilizationSource.getCurrentUtilization()));
            sourceElement.setAttribute("average", this.asPercentageString(utilizationSource.getAverageUtilization()));
            element.appendChild(sourceElement);
        }
        document.appendChild(element);
        return document;
    }

    private String asPercentageString(double utilization) {
        return Integer.toString((int)Math.round(utilization * 100.0));
    }
}

