/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.update.UpdatePackageInformation;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.RequiredVersion;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.info.InfoXMLSerializer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class UpdatePackageXMLSerializer {
    private XMLToolkit xmlToolkit = new XMLToolkit();

    public UpdatePackageInformation parsePackageInformation(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        return this.parsePackageInformation(root);
    }

    public UpdatePackageInformation parsePackageInformation(File updateXMLFile) throws SerializeException, FileNotFoundException {
        Element root = this.xmlToolkit.getDocumentRootFromFile(updateXMLFile);
        return this.parsePackageInformation(root);
    }

    private UpdatePackageInformation parsePackageInformation(Element root) {
        String requiredVersionString = root.getAttribute("required-version");
        String newVersionString = root.getAttribute("new-version");
        RequiredVersion requiredVersion = RequiredVersion.fromString((String)requiredVersionString);
        int build = InfoXMLSerializer.parseBuild((String)root.getAttribute("build"));
        Version newVersion = new Version(Version.fromString((String)newVersionString), build);
        DeviceMode deviceMode = null;
        String deviceIdentifier = null;
        if (root.hasAttribute("device-mode")) {
            deviceMode = DeviceMode.valueOf(StringUtils.trim((String)root.getAttribute("device-mode").toUpperCase()));
        }
        if (root.hasAttribute("device-identifier")) {
            deviceIdentifier = root.getAttribute("device-identifier");
        }
        return new UpdatePackageInformation(newVersion, requiredVersion, deviceMode, deviceIdentifier);
    }
}

