/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TaskIdXMLSerializer
implements XMLSerializer<UUID> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Collection<UUID> taskIds) {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("tasks");
        for (UUID taskId : taskIds) {
            Element labelElement = document.createElement("task");
            labelElement.setAttribute("id", taskId.toString());
            element.appendChild(labelElement);
        }
        document.appendChild(element);
        return document;
    }

    public List<UUID> parseXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        NodeList taskNodes = root.getElementsByTagName("task");
        ArrayList<UUID> taskIds = new ArrayList<UUID>(taskNodes.getLength());
        for (int index = 0; index < taskNodes.getLength(); ++index) {
            Element labelElement = (Element)taskNodes.item(index);
            UUID taskId = UUID.fromString(labelElement.getAttribute("id"));
            taskIds.add(taskId);
        }
        return taskIds;
    }
}

