/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.ChannelTableEntry;
import at.mrdevelopment.esl.wireless.RoamingAssignment;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import joptsimple.internal.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RoamingTableXMLSerializer
implements XMLSerializer<RoamingAssignment> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(RoamingTable roamingTable) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("roaming-table");
        root.setAttribute("protocol-id", Integer.toString(roamingTable.getProtocolId()));
        root.setAttribute("valid-for-minutes", Integer.toString(roamingTable.getValidTimeInMinutes()));
        root.setAttribute("ping-interval", Integer.toString(roamingTable.getPingIntervalInMinutes()));
        root.setAttribute("accept-all-labels", Boolean.toString(roamingTable.isAcceptAllLabels()));
        if (roamingTable.isEncryptionRequired()) {
            root.setAttribute("encryption-required", Boolean.toString(true));
        }
        if (!roamingTable.isAllowBlacklistedLabels()) {
            root.setAttribute("allow-blacklisted-labels", Boolean.toString(false));
        }
        if (roamingTable.hasKey()) {
            root.setAttribute("network-key", roamingTable.getKey().toBase64());
        }
        if (roamingTable.getSyncProfile() != SyncProfile.RETAIL_DEFAULT) {
            root.setAttribute("sync-profile", roamingTable.getSyncProfile().toString());
        }
        Element channelTableElement = this.channelTableToXML(document, roamingTable.getChannelTable());
        root.appendChild(channelTableElement);
        Element roamingAssignmentsElement = this.roamingAssignmentsToXML(document, roamingTable.getRoamingAssignments());
        root.appendChild(roamingAssignmentsElement);
        document.appendChild(root);
        return document;
    }

    private Element channelTableToXML(Document document, Collection<ChannelTableEntry> channelTable) {
        Element list = document.createElement("channel-table");
        for (ChannelTableEntry channelTableEntry : channelTable) {
            Element channelElement = document.createElement("channel-entry");
            channelElement.setAttribute("access-point", Integer.toString(channelTableEntry.getAccessPointId()));
            channelElement.setAttribute("channel", Integer.toString(channelTableEntry.getWirelessChannel().getChannelId()));
            list.appendChild(channelElement);
        }
        return list;
    }

    private Element roamingAssignmentsToXML(Document document, Collection<RoamingAssignment> roamingAssignments) {
        Element list = document.createElement("roaming-assignments");
        for (RoamingAssignment roamingAssignment : roamingAssignments) {
            Element roamingElement = document.createElement("roaming");
            roamingElement.setAttribute("address", roamingAssignment.getAddress().toString());
            roamingElement.setAttribute("type", roamingAssignment.getLabelType().toString());
            if (roamingAssignment.hasPin()) {
                roamingElement.setAttribute("pin", roamingAssignment.getPin().toBase64());
            }
            if (roamingAssignment.isAssigned()) {
                roamingElement.setAttribute("access-point", Integer.toString(roamingAssignment.getAccessPointId()));
            }
            list.appendChild(roamingElement);
        }
        return list;
    }

    public RoamingTable parseXML(InputStream xmlInputStream) throws SerializeException {
        try {
            Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
            int protocolId = root.hasAttribute("protocol-id") ? Integer.parseInt(root.getAttribute("protocol-id")) : 0;
            int validTimeInMinutes = Integer.parseInt(root.getAttribute("valid-for-minutes"));
            int pingIntervalInMinutes = Integer.parseInt(root.getAttribute("ping-interval"));
            boolean acceptAllLabels = root.hasAttribute("accept-all-labels") ? Boolean.parseBoolean(root.getAttribute("accept-all-labels")) : false;
            boolean encryptionRequired = root.hasAttribute("encryption-required") ? Boolean.parseBoolean(root.getAttribute("encryption-required")) : false;
            boolean allowBlacklistedLabels = root.hasAttribute("allow-blacklisted-labels") ? Boolean.parseBoolean(root.getAttribute("allow-blacklisted-labels")) : true;
            Key key = root.hasAttribute("network-key") ? Key.fromBase64(root.getAttribute("network-key")) : Key.emptyKey();
            SyncProfile syncProfile = SyncProfile.fromString(root.getAttribute("sync-profile"));
            Collection<ChannelTableEntry> channelTable = this.parseChannelTable(root);
            Collection<RoamingAssignment> roamingAssignments = this.parseRoamingAssignments(root);
            return new RoamingTable(protocolId, validTimeInMinutes, pingIntervalInMinutes, channelTable, roamingAssignments, acceptAllLabels, encryptionRequired, allowBlacklistedLabels, key, syncProfile);
        }
        catch (RuntimeException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private Collection<ChannelTableEntry> parseChannelTable(Element root) throws NumberFormatException, ArrayIndexOutOfBoundsException {
        NodeList nodes = root.getElementsByTagName("channel-entry");
        ArrayList<ChannelTableEntry> channelTable = new ArrayList<ChannelTableEntry>(nodes.getLength());
        for (int index = 0; index < nodes.getLength(); ++index) {
            Element channelElement = (Element)nodes.item(index);
            int accessPointId = Integer.parseInt(channelElement.getAttribute("access-point"));
            WirelessChannel wirelessChannel = WirelessChannel.fromString(channelElement.getAttribute("channel"));
            channelTable.add(new ChannelTableEntry(accessPointId, wirelessChannel));
        }
        return channelTable;
    }

    private Collection<RoamingAssignment> parseRoamingAssignments(Element root) throws NumberFormatException {
        NodeList nodes = root.getElementsByTagName("roaming");
        ArrayList<RoamingAssignment> roamingAssignments = new ArrayList<RoamingAssignment>(nodes.getLength());
        for (int index = 0; index < nodes.getLength(); ++index) {
            Element roamingElement = (Element)nodes.item(index);
            Address address = Address.fromString(roamingElement.getAttribute("address"));
            LabelType labelType = this.parseLabelType(roamingElement.getAttribute("type"));
            int accessPointId = roamingElement.hasAttribute("access-point") ? Integer.parseInt(roamingElement.getAttribute("access-point")) : 0;
            Pin pin = roamingElement.hasAttribute("pin") ? Pin.fromBase64(roamingElement.getAttribute("pin")) : null;
            roamingAssignments.add(new RoamingAssignment(address, pin, labelType, accessPointId));
        }
        return roamingAssignments;
    }

    private LabelType parseLabelType(String typeString) {
        return Strings.isNullOrEmpty((String)typeString) ? null : LabelType.fromString(typeString);
    }
}

