/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractInfoPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ExtendedInfoPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.InfoData;
import at.mrdevelopment.toolkit.tcp.thinap.text.InfoPacket;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OperationMetricsSerializer
implements XMLSerializer<ExtendedInfoPacket> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(InfoPacket infoPacket, ExtendedInfoPacket extendedInfoPacket) {
        Document document = this.xmlToolkit.newDocument();
        Element operationMetricsElement = document.createElement("operation-metrics");
        if (infoPacket != null && infoPacket.isValid()) {
            this.appendInfoPacket(infoPacket, operationMetricsElement, document);
        }
        if (extendedInfoPacket != null && extendedInfoPacket.isValid()) {
            this.appendExtendedInfoPacket(extendedInfoPacket, operationMetricsElement, document);
        }
        document.appendChild(operationMetricsElement);
        return document;
    }

    private void appendInfoPacket(InfoPacket infoPacket, Element root, Document document) {
        Element infoPacketElement = document.createElement("info-packet");
        this.appendInfoData((AbstractInfoPacket)infoPacket, infoPacketElement, document);
        root.appendChild(infoPacketElement);
    }

    private void appendInfoData(AbstractInfoPacket infoPacket, Element root, Document document) {
        Element messageTypeElement = document.createElement("message-type");
        messageTypeElement.setTextContent(infoPacket.getType().toString());
        root.appendChild(messageTypeElement);
        Element extendedInfosElement = document.createElement("infos");
        for (InfoData info : infoPacket.getInfos()) {
            Element headerInfoElement = null;
            Element extendedInfoElement = document.createElement("info");
            extendedInfoElement.setAttribute("category", info.getInfoCategory());
            for (Map.Entry entry : info.getEntries().entrySet()) {
                if (headerInfoElement == null) {
                    headerInfoElement = document.createElement("header-info");
                    for (int index = 0; index < ((List)entry.getValue()).size(); ++index) {
                        Element headerElement = document.createElement("header");
                        headerElement.setAttribute("value", String.valueOf(index + 1));
                        headerInfoElement.appendChild(headerElement);
                    }
                }
                Element extendedInfoEntryElement = document.createElement("info-entry");
                extendedInfoEntryElement.setAttribute("key", (String)entry.getKey());
                for (String value : (List)entry.getValue()) {
                    Element extendedInfoEntryValueElement = document.createElement("info-entry-value");
                    extendedInfoEntryValueElement.setAttribute("value", value);
                    extendedInfoEntryElement.appendChild(extendedInfoEntryValueElement);
                }
                extendedInfoElement.appendChild(extendedInfoEntryElement);
            }
            extendedInfosElement.appendChild(extendedInfoElement);
            extendedInfoElement.appendChild(headerInfoElement);
        }
        root.appendChild(extendedInfosElement);
    }

    private void appendExtendedInfoPacket(ExtendedInfoPacket extendedInfoPacket, Element root, Document document) {
        Element extendedInfoPacketElement = document.createElement("extended-info-packet");
        this.appendInfoData((AbstractInfoPacket)extendedInfoPacket, extendedInfoPacketElement, document);
        root.appendChild(extendedInfoPacketElement);
    }
}

