/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.admin.platform.NetworkProperty;
import at.mrdevelopment.esl.network.NetworkStatus;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NetworkStatusXMLSerializer
implements XMLSerializer<NetworkStatus> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Element toXML(Document document, NetworkStatus networkStatus) {
        Element element = document.createElement("network-status");
        this.addProperties(document, element, networkStatus.getNetworkProperties());
        return element;
    }

    public Document toXML(NetworkStatus networkStatus) {
        Document document = this.xmlToolkit.newDocument();
        document.appendChild(this.toXML(document, networkStatus));
        return document;
    }

    private void addProperties(Document document, Element element, Collection<NetworkProperty> properties) {
        for (NetworkProperty property : properties) {
            Element propertyElement = document.createElement("network-property");
            propertyElement.setAttribute("adapter-name", property.getAdapterName());
            propertyElement.setAttribute("interface-name", property.getInterfaceName());
            propertyElement.setAttribute("hardware-address", property.getHardwareAddresString());
            propertyElement.setAttribute("address", property.getAddress());
            propertyElement.setAttribute("broadcast", property.getBroadcast());
            propertyElement.setAttribute("subnet", property.getSubnetMask());
            element.appendChild(propertyElement);
        }
    }

    public NetworkStatus parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        try {
            return this.parseNetworkStatusFromXML(root);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private NetworkStatus parseNetworkStatusFromXML(Element element) throws ParseException, ClassNotFoundException {
        ArrayList<NetworkProperty> networkProperties = new ArrayList<NetworkProperty>();
        NodeList properties = element.getElementsByTagName("network-property");
        for (int index = 0; index < properties.getLength(); ++index) {
            Element propertyElement = (Element)properties.item(index);
            String adapterName = propertyElement.getAttribute("adapter-name");
            String interfaceName = propertyElement.getAttribute("interface-name");
            String hardwareAddress = propertyElement.getAttribute("hardware-address");
            String address = propertyElement.getAttribute("address");
            String broadcast = propertyElement.getAttribute("broadcast");
            String subnet = propertyElement.getAttribute("subnet");
            networkProperties.add(new NetworkProperty(hardwareAddress, address, subnet, broadcast, interfaceName, adapterName));
        }
        return new NetworkStatus(networkProperties);
    }
}

