/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LabelEventXMLSerializer
implements XMLSerializer<JoinRequest> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Element labelEventToXML(Document document, LabelEvent labelEvent) {
        Element element = document.createElement("event");
        element.setAttribute("id", labelEvent.getEventId().toString());
        element.setAttribute("address", labelEvent.getLabelAddress().toString());
        element.setAttribute("type", Integer.toString(labelEvent.getEventType()));
        element.setAttribute("data", Integer.toString(labelEvent.getEventData()));
        element.setAttribute("time", this.xmlToolkit.formatTime(labelEvent.getReceivedTime()));
        element.setAttribute("revision", Integer.toString(labelEvent.getRevision()));
        element.setAttribute("confirmed", Boolean.toString(labelEvent.isConfirmed()));
        return element;
    }

    public void updateTime(Element element, DateTime time, DateTime now) {
        element.setAttribute("time-relative", Long.toString(this.xmlToolkit.getRelativeTime(now, time)));
    }

    public Document newDocument() {
        return this.xmlToolkit.newDocument();
    }

    public Collection<LabelEvent> parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        NodeList nodes = root.getElementsByTagName("event");
        ArrayList<LabelEvent> labelEvents = new ArrayList<LabelEvent>(nodes.getLength());
        DateTime now = DateTime.now();
        for (int index = 0; index < nodes.getLength(); ++index) {
            try {
                LabelEvent labelEvent = this.parseLabelEventFromXML((Element)nodes.item(index), now);
                labelEvents.add(labelEvent);
                continue;
            }
            catch (RuntimeException exc) {
                throw new SerializeException((Throwable)exc);
            }
        }
        return labelEvents;
    }

    private LabelEvent parseLabelEventFromXML(Element element, DateTime now) throws NumberFormatException {
        UUID eventId = UUID.fromString(element.getAttribute("id"));
        Address labelAddress = Address.fromString(element.getAttribute("address"));
        DateTime time = this.xmlToolkit.getLocalTimeFromRelativeTime(now, Long.parseLong(element.getAttribute("time-relative")));
        int eventType = Integer.parseInt(element.getAttribute("type"));
        int eventData = Integer.parseInt(element.getAttribute("data"));
        int revision = 0;
        if (element.hasAttribute("revision")) {
            revision = Integer.parseInt(element.getAttribute("revision"));
        }
        boolean confirmed = true;
        if (element.hasAttribute("confirmed")) {
            confirmed = Boolean.parseBoolean(element.getAttribute("confirmed"));
        }
        return new LabelEvent(eventId, labelAddress, time, eventType, eventData, revision, confirmed);
    }
}

