/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.certificate.ESLKeyStore;
import at.mrdevelopment.esl.xml.CertificateXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public class KeyStoreXMLSerializer
extends CertificateXMLSerializer
implements XMLSerializer<ESLKeyStore> {
    private ESLKeyStore keyStore;

    public Document certificateToXML(ESLKeyStore keyStore) throws InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, DOMException, IOException {
        this.keyStore = keyStore;
        return super.certificateToXML();
    }

    public Document certificationRequestPEMToXML(ESLKeyStore keyStore) throws InvalidKeyException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException, IOException {
        this.keyStore = keyStore;
        return super.certificationRequestPEMToXML();
    }

    public Document toKeyPairXMLForm(ESLKeyStore keyStore) throws UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, IOException {
        this.keyStore = keyStore;
        return super.toKeyPairXMLForm("/service/config/certificate/keypair.html");
    }

    @Override
    protected X509Certificate getCertificate() {
        try {
            return (X509Certificate)this.keyStore.getCertificate();
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    protected String getCertificationRequestPEM() {
        try {
            return this.keyStore.getCertificationRequestPEM();
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    protected String getPrivateKeyPEM() {
        try {
            return this.keyStore.getPrivateKeyPEM();
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    protected String getPublicKeyPEM() {
        try {
            return this.keyStore.getPublicKeyPEM();
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    protected String getProtocol() {
        return "SSL";
    }
}

