/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.JoinStatus;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JoinRequestXMLSerializer
implements XMLSerializer<JoinRequest> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public String formatTime(DateTime dateTime) {
        return this.xmlToolkit.formatTime(dateTime);
    }

    public void updateTime(Element element, DateTime joinTime, DateTime now) {
        element.setAttribute("time-relative", Long.toString(this.xmlToolkit.getRelativeTime(now, joinTime)));
    }

    public Document newDocument() {
        return this.xmlToolkit.newDocument();
    }

    public Collection<JoinRequest> parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        NodeList nodes = root.getElementsByTagName("join-request");
        ArrayList<JoinRequest> joinRequests = new ArrayList<JoinRequest>(nodes.getLength());
        DateTime now = DateTime.now();
        for (int index = 0; index < nodes.getLength(); ++index) {
            try {
                JoinRequest joinRequest = this.parseJoinRequestFromXML((Element)nodes.item(index), now);
                joinRequests.add(joinRequest);
                continue;
            }
            catch (RuntimeException exc) {
                throw new SerializeException((Throwable)exc);
            }
        }
        return joinRequests;
    }

    private JoinRequest parseJoinRequestFromXML(Element element, DateTime now) throws NumberFormatException {
        Address labelAddress = Address.fromString(element.getAttribute("address"));
        int accessPointId = Integer.parseInt(element.getAttribute("access-point"));
        DateTime time = this.xmlToolkit.getLocalTimeFromRelativeTime(now, Long.parseLong(element.getAttribute("time-relative")));
        JoinStatus joinStatus = JoinStatus.valueOf(element.getAttribute("status"));
        return new JoinRequest(labelAddress, accessPointId, time, joinStatus);
    }
}

