/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.certificate.CertificateProperties;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpFormParser;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class CertificateXMLSerializer {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document certificateToXML() throws InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, DOMException, IOException {
        X509Certificate cert = this.getCertificate();
        Document document = this.xmlToolkit.newDocument();
        Element certificate = document.createElement("certificate");
        document.appendChild(certificate);
        certificate.setAttribute("protocol", this.getProtocol());
        Element version = document.createElement("version");
        certificate.appendChild(version);
        version.setTextContent(Integer.toString(cert.getVersion()));
        Element serialNumber = document.createElement("serialNumber");
        certificate.appendChild(serialNumber);
        serialNumber.setTextContent(cert.getSerialNumber().toString());
        Element subjectDN = document.createElement("subjectDN");
        certificate.appendChild(subjectDN);
        subjectDN.setTextContent(((Object)cert.getSubjectDN()).toString());
        Element issuerDN = document.createElement("issuerDN");
        certificate.appendChild(issuerDN);
        issuerDN.setTextContent(((Object)cert.getIssuerDN()).toString());
        Element notBefore = document.createElement("notBefore");
        certificate.appendChild(notBefore);
        notBefore.setTextContent(cert.getNotBefore().toString());
        Element notAfter = document.createElement("notAfter");
        certificate.appendChild(notAfter);
        notAfter.setTextContent(cert.getNotAfter().toString());
        return document;
    }

    public Document certificationRequestPEMToXML() throws InvalidKeyException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException, IOException {
        String pem = this.getCertificationRequestPEM();
        Document document = this.xmlToolkit.newDocument();
        Element csr = document.createElement("certificate-signing-request");
        csr.setTextContent(pem);
        document.appendChild(csr);
        return document;
    }

    public Document toKeyPairXMLForm(String url) throws UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, IOException {
        Document document = this.xmlToolkit.newDocument();
        String privatePEM = this.getPrivateKeyPEM();
        String publicPEM = this.getPublicKeyPEM();
        Element rootForm = document.createElement("keypair-form");
        Element form = document.createElement("subform");
        Element publicText = document.createElement("textarea");
        Element privateText = document.createElement("textarea");
        Element button = document.createElement("confirm-button");
        Element root = document.createElement("root");
        Element header = document.createElement("header");
        header.setTextContent("Change Keypair");
        publicText.setAttribute("name", "publicKey");
        privateText.setAttribute("name", "privateKey");
        publicText.setAttribute("caption", "Public Key PEM");
        privateText.setAttribute("caption", "Private Key PEM");
        publicText.setAttribute("rows", "10");
        privateText.setAttribute("rows", "28");
        publicText.setAttribute("cols", "70");
        privateText.setAttribute("cols", "70");
        publicText.setTextContent(publicPEM);
        privateText.setTextContent(privatePEM);
        form.setAttribute("action", url);
        form.setAttribute("method", "POST");
        form.setAttribute("name", "keys");
        button.setAttribute("caption", "Change Keys");
        button.setAttribute("question", "Do you really want to change the key pair?");
        root.appendChild(header);
        form.appendChild(publicText);
        form.appendChild(privateText);
        rootForm.appendChild(form);
        form.appendChild(button);
        root.appendChild(rootForm);
        document.appendChild(root);
        return document;
    }

    public Document toXML(CertificateProperties properties) {
        Document document = this.xmlToolkit.newDocument();
        Element propertiesElement = document.createElement("certificate-properties");
        propertiesElement.setAttribute("c", properties.getC());
        propertiesElement.setAttribute("cn", properties.getCn());
        propertiesElement.setAttribute("l", properties.getL());
        propertiesElement.setAttribute("o", properties.getO());
        propertiesElement.setAttribute("ou", properties.getOu());
        propertiesElement.setAttribute("st", properties.getSt());
        propertiesElement.setAttribute("valid", String.valueOf(properties.getValidYears()));
        document.appendChild(propertiesElement);
        return document;
    }

    public CertificateProperties parseCertifcateProperties(HttpEntity body) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            String c = formParser.getValue("c");
            String cn = formParser.getValue("cn");
            String o = formParser.getValue("o");
            String ou = formParser.getValue("ou");
            String st = formParser.getValue("st");
            String l = formParser.getValue("l");
            int validYears = Integer.valueOf(formParser.getValue("valid"));
            return new CertificateProperties(c, cn, o, ou, l, st, validYears);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public Document trustedCertificatesToXML(Map<String, X509Certificate> trustedCertificates) {
        Document document = this.xmlToolkit.newDocument();
        this.trustedCertificatesToXML(document, trustedCertificates);
        return document;
    }

    private void trustedCertificatesToXML(Document document, Map<String, X509Certificate> trustedCertificates) {
        Element root = document.createElement("trusted-certificates");
        this.trustedCertificatesToXML(document, root, trustedCertificates);
        document.appendChild(root);
    }

    public void trustedCertificatesToXML(Document document, Element root, Map<String, X509Certificate> trustedCertificates) {
        for (Map.Entry<String, X509Certificate> entry : trustedCertificates.entrySet()) {
            X509Certificate certificate = entry.getValue();
            Element certificateElement = document.createElement("certificate");
            certificateElement.setAttribute("alias", entry.getKey());
            certificateElement.setAttribute("not-before", certificate.getNotBefore().toString());
            certificateElement.setAttribute("not-after", certificate.getNotAfter().toString());
            Element subjectElement = document.createElement("subject");
            subjectElement.setTextContent(certificate.getSubjectX500Principal().toString());
            certificateElement.appendChild(subjectElement);
            Element issuerElement = document.createElement("issuer");
            issuerElement.setTextContent(certificate.getIssuerX500Principal().toString());
            certificateElement.appendChild(issuerElement);
            root.appendChild(certificateElement);
        }
    }

    protected abstract X509Certificate getCertificate();

    protected abstract String getCertificationRequestPEM();

    protected abstract String getPrivateKeyPEM();

    protected abstract String getPublicKeyPEM();

    protected abstract String getProtocol();
}

