/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.certificate.CertificateWriter;
import at.mrdevelopment.esl.xml.CertificateXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class AccessPointTLSCertificateXMLSerializer
extends CertificateXMLSerializer
implements XMLSerializer<X509Certificate> {
    private final CertificateWriter certificateWriter = new CertificateWriter();

    @Override
    protected X509Certificate getCertificate() {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            FileInputStream in = new FileInputStream(new File("/esl/security/thinap/chain.pem"));
            return (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (CertificateException e) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected String getCertificationRequestPEM() {
        return null;
    }

    @Override
    protected String getPrivateKeyPEM() {
        return null;
    }

    @Override
    protected String getPublicKeyPEM() {
        return null;
    }

    @Override
    protected String getProtocol() {
        return "TLS";
    }

    public String getCertificatePEM() {
        try {
            return this.certificateWriter.writePEM(this.getCertificate());
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] getCertificateDER() {
        try {
            return this.certificateWriter.writeDER(this.getCertificate());
        }
        catch (CertificateEncodingException e) {
            return null;
        }
    }
}

